# Python va lire le fichier 'sequence_arn.txt'

file = open('sequence_arn.txt', 'r')	# ouverture
sequence = file.read()	# lecture de la première ligne et stockage de cette ligne dans la variable sequence
print("Sequence ARN: ", sequence) # ici on affiche dans le terminal la valeur de la variable sequence, précédée par "Sequence ARN: "

# On stock le code génétique dans un tableau nommé codon. Il permet d'associer chaque codon à son acide aminé correspondant.

codon = {"UUU" : "F", "CUU" : "L", "AUU" : "I", "GUU" : "V",
           "UUC" : "F", "CUC" : "L", "AUC" : "I", "GUC" : "V",
           "UUA" : "L", "CUA" : "L", "AUA" : "I", "GUA" : "V",
           "UUG" : "L", "CUG" : "L", "AUG" : "M", "GUG" : "V",
           "UCU" : "S", "CCU" : "P", "ACU" : "T", "GCU" : "A",
           "UCC" : "S", "CCC" : "P", "ACC" : "T", "GCC" : "A",
           "UCA" : "S", "CCA" : "P", "ACA" : "T", "GCA" : "A",
           "UCG" : "S", "CCG" : "P", "ACG" : "T", "GCG" : "A",
           "UAU" : "Y", "CAU" : "H", "AAU" : "N", "GAU" : "D",
           "UAC" : "Y", "CAC" : "H", "AAC" : "N", "GAC" : "D",
           "UAA" : "STOP", "CAA" : "Q", "AAA" : "K", "GAA" : "E",
           "UAG" : "STOP", "CAG" : "Q", "AAG" : "K", "GAG" : "E",
           "UGU" : "C", "CGU" : "R", "AGU" : "S", "GGU" : "G",
           "UGC" : "C", "CGC" : "R", "AGC" : "S", "GGC" : "G",
           "UGA" : "STOP", "CGA" : "R", "AGA" : "R", "GGA" : "G",
           "UGG" : "W", "CGG" : "R", "AGG" : "R", "GGG" : "G" 
           }

# On prépare une variable proteine dans laquelle seront stockés les acides aminés de chaque codon de la séquence

proteine = ""

# Grace à une boucle, on parcours la séquence de 3 nucléotides en 3 nucléotides, donc de codon en codon, et on ajoute, pour chaque codon l'acide aminé correspondant dans la variable proteine

for position in range(0, len(sequence)-(3+len(sequence)%3), 3):
    if codon[sequence[position:position+3]] == "STOP" :
        break
    proteine += codon[sequence[position:position+3]]

# On affiche dans le terminal la valeur de la variable proteine, précédée par "Sequence proteique: "

print("Sequence proteique: ", proteine)

# Fin du programme

