# -*- coding: utf-8 -*-

################################
#			       #
#     Symétrie horizontale     #
#			       #
################################

# Importation de la librairie PIL
from PIL import Image

# Ouverture du fichier image
fichierImage = 'photo.jpg'
imageSource = Image.open(fichierImage)

# Affichage de l'image pour comparaison
imageSource.show()

# récupération de la largeur et hauteur de l'image
largeur,hauteur = imageSource.size

# création d'une image de même type
imageFinale = Image.new(imageSource.mode,imageSource.size)

# Symétrie horizontale
for x in range(largeur):
	for y in range(hauteur):
		pixel = imageSource.getpixel((x,y))
		imageFinale.putpixel((-x+largeur-1,y), pixel)

# Affichage de l'image finale et enregistrement
imageFinale.show()
imageFinale.save("Image finale - symetrie horizontale.jpg")

# Fermeture du fichier image
imageSource.close()
