# -*- coding: utf-8 -*-

#########################
#			#
#     Image Pop Art     #
#			#
#########################

# Importation des librairies
from PIL import Image

# Ouverture du fichier photo et affichage
fichierImage = 'photo.jpg'
imageSource = Image.open(fichierImage)

# Affichage de l'image pour comparaison
imageSource.show()

# Récupération de la largeur et hauteur de l'image
largeur, hauteur = imageSource.size

# Redimensionnement de l'image source en une image de taille moitié
imageVignette = imageSource.resize((largeur // 2, hauteur // 2), Image.BICUBIC) # Division par 2 de la taille // permet de ne récupérer que le quotien de la division
largeurVignette,hauteurVignette= imageVignette.size # récupération de la largeur et hauteur de l'image redimensionnée

# Création des vignettes avec filtre de couleur
image1 = Image.new(imageVignette.mode,imageVignette.size) #jaune R255 V255 B0


# boucle de traitement des pixels pour appliquer filtre couleur
for x in range(largeurVignette):
	for y in range(hauteurVignette):
		pixel = imageVignette.getpixel((x,y)) # Lecture du pixel sur la vignette d'origine
		# Filtre jaune
		p = (int(255*0.4 + pixel[0]*0.6), int(255*0.4 + pixel[1]*0.6), int(0*0.4 + pixel[2]*0.6)) # Application d'une composante jaune sur le pixel temporaire
		image1.putpixel((x,y), p) # Composition de la nouvelle image
		# Filtre magenta
		p = (int(VALEUR*0.4 + pixel[0]*0.6), int(VALEUR*0.4 + pixel[1]*0.6), int(VALEUR*0.4 + pixel[2]*0.6))
		image2.putpixel((x,y), p)				
		# Filtre bleu
		p = (int(VALEUR*0.4 + pixel[0]*0.6), int(VALEUR*0.4 + pixel[1]*0.6), int(VALEUR*0.4 + pixel[2]*0.6))
		image3.putpixel((x,y), p)
		# Filtre vert
		p = (int(VALEUR*0.4 + pixel[0]*0.6), int(VALEUR*0.4 + pixel[1]*0.6), int(VALEUR*0.4 + pixel[2]*0.6))
		image4.putpixel((x,y), p)

# Création d'une image finale de la taille de l'image d'origine et mise en place des vignettes colorées dans cette image
imageFinale = Image.new(imageSource.mode,imageSource.size)
imageFinale.paste(im=image1, box=(0, 0))
imageFinale.paste(im=image2, box=(largeurVignette, 0))
imageFinale.paste ### Complèter la partie manquante ...
imageFinale.paste ### Complèter la partie manquante ...

# Affichage de l'image et enregistrement
imageFinale.show()
imageFinale.save("Image finale - Pop Art.jpg")

# Fermeture du fichier image
imageSource.close()
