/*
 *  /MathJax/jax/input/TeX/jax.js
 *  
 *  Copyright (c) 2012 Design Science, Inc.
 *
 *  Part of the MathJax library.
 *  See http://www.mathjax.org for details.
 * 
 *  Licensed under the Apache License, Version 2.0;
 *  you may not use this file except in compliance with the License.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */

(function(d,c,i){var h,g="\u00A0";var e=MathJax.Object.Subclass({Init:function(l,k){this.global={isInner:k};this.data=[b.start(this.global)];if(l){this.data[0].env=l}this.env=this.data[0].env},Push:function(){var l,k,n,o;for(l=0,k=arguments.length;l<k;l++){n=arguments[l];if(n instanceof h.mbase){n=b.mml(n)}n.global=this.global;o=(this.data.length?this.Top().checkItem(n):true);if(o instanceof Array){this.Pop();this.Push.apply(this,o)}else{if(o instanceof b){this.Pop();this.Push(o)}else{if(o){this.data.push(n);if(n.env){for(var p in this.env){if(this.env.hasOwnProperty(p)){n.env[p]=this.env[p]}}this.env=n.env}else{n.env=this.env}}}}}},Pop:function(){var k=this.data.pop();if(!k.isOpen){delete k.env}this.env=(this.data.length?this.Top().env:{});return k},Top:function(k){if(k==null){k=1}if(this.data.length<k){return null}return this.data[this.data.length-k]},Prev:function(k){var l=this.Top();if(k){return l.data[l.data.length-1]}else{return l.Pop()}},toString:function(){return"stack[\n  "+this.data.join("\n  ")+"\n]"}});var b=e.Item=MathJax.Object.Subclass({type:"base",closeError:"Extra close brace or missing open brace",rightError:"Missing \\left or extra \\right",Init:function(){if(this.isOpen){this.env={}}this.data=[];this.Push.apply(this,arguments)},Push:function(){this.data.push.apply(this.data,arguments)},Pop:function(){return this.data.pop()},mmlData:function(k,l){if(k==null){k=true}if(this.data.length===1&&!l){return this.data[0]}return h.mrow.apply(h,this.data).With((k?{inferred:true}:{}))},checkItem:function(k){if(k.type==="over"&&this.isOpen){k.num=this.mmlData(false);this.data=[]}if(k.type==="cell"&&this.isOpen){if(k.linebreak){return false}d.Error("Misplaced "+k.name)}if(k.isClose&&this[k.type+"Error"]){d.Error(this[k.type+"Error"])}if(!k.isNotStack){return true}this.Push(k.data[0]);return false},With:function(k){for(var l in k){if(k.hasOwnProperty(l)){this[l]=k[l]}}return this},toString:function(){return this.type+"["+this.data.join("; ")+"]"}});b.start=b.Subclass({type:"start",isOpen:true,Init:function(k){this.SUPER(arguments).Init.call(this);this.global=k},checkItem:function(k){if(k.type==="stop"){return b.mml(this.mmlData())}return this.SUPER(arguments).checkItem.call(this,k)}});b.stop=b.Subclass({type:"stop",isClose:true});b.open=b.Subclass({type:"open",isOpen:true,stopError:"Extra open brace or missing close brace",checkItem:function(l){if(l.type==="close"){var k=this.mmlData();return b.mml(h.TeXAtom(k))}return this.SUPER(arguments).checkItem.call(this,l)}});b.close=b.Subclass({type:"close",isClose:true});b.prime=b.Subclass({type:"prime",checkItem:function(k){if(this.data[0].type!=="msubsup"){return[h.msup(this.data[0],this.data[1]),k]}this.data[0].SetData(this.data[0].sup,this.data[1]);return[this.data[0],k]}});b.subsup=b.Subclass({type:"subsup",stopError:"Missing superscript or subscript argument",checkItem:function(l){var k=["","subscript","superscript"][this.position];if(l.type==="open"||l.type==="left"){return true}if(l.type==="mml"){if(this.primes){if(this.position!==2){this.data[0].SetData(2,this.primes)}else{l.data[0]=h.mrow(this.primes.With({variantForm:true}),l.data[0])}}this.data[0].SetData(this.position,l.data[0]);return b.mml(this.data[0])}if(this.SUPER(arguments).checkItem.call(this,l)){d.Error("Missing open brace for "+k)}},Pop:function(){}});b.over=b.Subclass({type:"over",isClose:true,name:"\\over",checkItem:function(m,k){if(m.type==="over"){d.Error("Ambiguous use of "+m.name)}if(m.isClose){var l=h.mfrac(this.num,this.mmlData(false));if(this.thickness!=null){l.linethickness=this.thickness}if(this.open||this.close){l.texClass=h.TEXCLASS.INNER;l.texWithDelims=true;l=h.mfenced(l).With({open:this.open,close:this.close})}return[b.mml(l),m]}return this.SUPER(arguments).checkItem.call(this,m)},toString:function(){return"over["+this.num+" / "+this.data.join("; ")+"]"}});b.left=b.Subclass({type:"left",isOpen:true,delim:"(",stopError:"Extra \\left or missing \\right",checkItem:function(l){if(l.type==="right"){var k=h.mfenced(this.data.length===1?this.data[0]:h.mrow.apply(h,this.data));return b.mml(k.With({open:this.delim,close:l.delim}))}return this.SUPER(arguments).checkItem.call(this,l)}});b.right=b.Subclass({type:"right",isClose:true,delim:")"});b.begin=b.Subclass({type:"begin",isOpen:true,checkItem:function(k){if(k.type==="end"){if(k.name!==this.name){d.Error("\\begin{"+this.name+"} ended with \\end{"+k.name+"}")}if(!this.end){return b.mml(this.mmlData())}return this.parse[this.end].call(this.parse,this,this.data)}if(k.type==="stop"){d.Error("Missing \\end{"+this.name+"}")}return this.SUPER(arguments).checkItem.call(this,k)}});b.end=b.Subclass({type:"end",isClose:true});b.style=b.Subclass({type:"style",checkItem:function(l){if(!l.isClose){return this.SUPER(arguments).checkItem.call(this,l)}var k=h.mstyle.apply(h,this.data).With(this.styles);return[b.mml(k),l]}});b.position=b.Subclass({type:"position",checkItem:function(l){if(l.isClose){d.Error("Missing box for "+this.name)}if(l.isNotStack){var k=l.mmlData();switch(this.move){case"vertical":k=h.mpadded(k).With({height:this.dh,depth:this.dd,voffset:this.dh});return[b.mml(k)];case"horizontal":return[b.mml(this.left),l,b.mml(this.right)]}}return this.SUPER(arguments).checkItem.call(this,l)}});b.array=b.Subclass({type:"array",isOpen:true,arraydef:{},Init:function(){this.table=[];this.row=[];this.env={};this.frame=[];this.SUPER(arguments).Init.apply(this,arguments)},checkItem:function(l){if(l.isClose&&l.type!=="over"){if(l.isEntry){this.EndEntry();this.clearEnv();return false}if(l.isCR){this.EndEntry();this.EndRow();this.clearEnv();return false}this.EndTable();this.clearEnv();var k=h.mtable.apply(h,this.table).With(this.arraydef);if(this.frame.length===4){k.frame=(this.frame.dashed?"dashed":"solid")}else{if(this.frame.length){k.hasFrame=true;if(this.arraydef.rowlines){this.arraydef.rowlines=this.arraydef.rowlines.replace(/none( none)+$/,"none")}k=h.menclose(k).With({notation:this.frame.join(" "),isFrame:true});if((this.arraydef.columnlines||"none")!="none"||(this.arraydef.rowlines||"none")!="none"){k.padding=0}}}if(this.open||this.close){k=h.mfenced(k).With({open:this.open,close:this.close})}k=b.mml(k);if(this.requireClose){if(l.type==="close"){return k}d.Error("Missing close brace")}return[k,l]}return this.SUPER(arguments).checkItem.call(this,l)},EndEntry:function(){this.row.push(h.mtd.apply(h,this.data));this.data=[]},EndRow:function(){this.table.push(h.mtr.apply(h,this.row));this.row=[]},EndTable:function(){if(this.data.length||this.row.length){this.EndEntry();this.EndRow()}this.checkLines()},checkLines:function(){if(this.arraydef.rowlines){var k=this.arraydef.rowlines.split(/ /);if(k.length===this.table.length){this.frame.push("bottom");k.pop();this.arraydef.rowlines=k.join(" ")}else{if(k.length<this.table.length-1){this.arraydef.rowlines+=" none"}}}if(this.rowspacing){var l=this.arraydef.rowspacing.split(/ /);while(l.length<this.table.length){l.push(this.rowspacing+"em")}this.arraydef.rowspacing=l.join(" ")}},clearEnv:function(){for(var k in this.env){if(this.env.hasOwnProperty(k)){delete this.env[k]}}}});b.cell=b.Subclass({type:"cell",isClose:true});b.mml=b.Subclass({type:"mml",isNotStack:true,Add:function(){this.data.push.apply(this.data,arguments);return this}});b.fn=b.Subclass({type:"fn",checkItem:function(l){if(this.data[0]){if(l.type!=="mml"||!l.data[0]){return[this.data[0],l]}if(l.data[0].isa(h.mspace)){return[this.data[0],l]}var k=l.data[0];if(k.isEmbellished()){k=k.CoreMO()}if([0,0,1,1,0,1,1,0,0,0][k.Get("texClass")]){return[this.data[0],l]}return[this.data[0],h.mo(h.entity("#x2061")).With({texClass:h.TEXCLASS.NONE}),l]}return this.SUPER(arguments).checkItem.apply(this,arguments)}});b.not=b.Subclass({type:"not",checkItem:function(l){var k,m;if(l.type==="open"||l.type==="left"){return true}if(l.type==="mml"&&l.data[0].type.match(/^(mo|mi|mtext)$/)){k=l.data[0],m=k.data.join("");if(m.length===1&&!k.movesupsub){m=b.not.remap[m.charCodeAt(0)];if(m){k.SetData(0,h.chars(String.fromCharCode(m)))}else{k.Append(h.chars("\u0338"))}return l}}k=h.mpadded(h.mtext("\u29F8")).With({width:0});k=h.TeXAtom(k).With({texClass:h.TEXCLASS.REL});return[k,l]}});b.not.remap={8592:8602,8594:8603,8596:8622,8656:8653,8658:8655,8660:8654,8712:8713,8715:8716,8739:8740,8741:8742,8764:8769,126:8769,8771:8772,8773:8775,8776:8777,8781:8813,61:8800,8801:8802,60:8814,62:8815,8804:8816,8805:8817,8818:8820,8819:8821,8822:8824,8823:8825,8826:8832,8827:8833,8834:8836,8835:8837,8838:8840,8839:8841,8866:8876,8872:8877,8873:8878,8875:8879,8828:8928,8829:8929,8849:8930,8850:8931,8882:8938,8883:8939,8884:8940,8885:8941,8707:8708};b.dots=b.Subclass({type:"dots",checkItem:function(l){if(l.type==="open"||l.type==="left"){return true}var m=this.ldots;if(l.type==="mml"&&l.data[0].isEmbellished()){var k=l.data[0].CoreMO().Get("texClass");if(k===h.TEXCLASS.BIN||k===h.TEXCLASS.REL){m=this.cdots}}return[m,l]}});var f={Add:function(k,n,m){if(!n){n=this}for(var l in k){if(k.hasOwnProperty(l)){if(typeof k[l]==="object"&&!(k[l] instanceof Array)&&(typeof n[l]==="object"||typeof n[l]==="function")){this.Add(k[l],n[l],k[l],m)}else{if(!n[l]||!n[l].isUser||!m){n[l]=k[l]}}}}return n}};var j=function(){h=MathJax.ElementJax.mml;c.Insert(f,{letter:/[a-z]/i,digit:/[0-9.]/,number:/^(?:[0-9]+(?:\{,\}[0-9]{3})*(?:\.[0-9]*)*|\.[0-9]+)/,special:{"\\":"ControlSequence","{":"Open","}":"Close","~":"Tilde","^":"Superscript",_:"Subscript"," ":"Space","\t":"Space","\r":"Space","\n":"Space","'":"Prime","%":"Comment","&":"Entry","#":"Hash","\u2019":"Prime"},remap:{"-":"2212","*":"2217"},mathchar0mi:{alpha:"03B1",beta:"03B2",gamma:"03B3",delta:"03B4",epsilon:"03F5",zeta:"03B6",eta:"03B7",theta:"03B8",iota:"03B9",kappa:"03BA",lambda:"03BB",mu:"03BC",nu:"03BD",xi:"03BE",omicron:"03BF",pi:"03C0",rho:"03C1",sigma:"03C3",tau:"03C4",upsilon:"03C5",phi:"03D5",chi:"03C7",psi:"03C8",omega:"03C9",varepsilon:"03B5",vartheta:"03D1",varpi:"03D6",varrho:"03F1",varsigma:"03C2",varphi:"03C6",S:["00A7",{mathvariant:h.VARIANT.NORMAL}],aleph:["2135",{mathvariant:h.VARIANT.NORMAL}],hbar:["210F",{variantForm:true}],imath:"0131",jmath:"0237",ell:"2113",wp:["2118",{mathvariant:h.VARIANT.NORMAL}],Re:["211C",{mathvariant:h.VARIANT.NORMAL}],Im:["2111",{mathvariant:h.VARIANT.NORMAL}],partial:["2202",{mathvariant:h.VARIANT.NORMAL}],infty:["221E",{mathvariant:h.VARIANT.NORMAL}],prime:["2032",{mathvariant:h.VARIANT.NORMAL,variantForm:true}],emptyset:["2205",{mathvariant:h.VARIANT.NORMAL}],nabla:["2207",{mathvariant:h.VARIANT.NORMAL}],top:["22A4",{mathvariant:h.VARIANT.NORMAL}],bot:["22A5",{mathvariant:h.VARIANT.NORMAL}],angle:["2220",{mathvariant:h.VARIANT.NORMAL}],triangle:["25B3",{mathvariant:h.VARIANT.NORMAL}],backslash:["2216",{mathvariant:h.VARIANT.NORMAL,variantForm:true}],forall:["2200",{mathvariant:h.VARIANT.NORMAL}],exists:["2203",{mathvariant:h.VARIANT.NORMAL}],neg:["00AC",{mathvariant:h.VARIANT.NORMAL}],lnot:["00AC",{mathvariant:h.VARIANT.NORMAL}],flat:["266D",{mathvariant:h.VARIANT.NORMAL}],natural:["266E",{mathvariant:h.VARIANT.NORMAL}],sharp:["266F",{mathvariant:h.VARIANT.NORMAL}],clubsuit:["2663",{mathvariant:h.VARIANT.NORMAL}],diamondsuit:["2662",{mathvariant:h.VARIANT.NORMAL}],heartsuit:["2661",{mathvariant:h.VARIANT.NORMAL}],spadesuit:["2660",{mathvariant:h.VARIANT.NORMAL}]},mathchar0mo:{surd:"221A",coprod:["2210",{texClass:h.TEXCLASS.OP,movesupsub:true}],bigvee:["22C1",{texClass:h.TEXCLASS.OP,movesupsub:true}],bigwedge:["22C0",{texClass:h.TEXCLASS.OP,movesupsub:true}],biguplus:["2A04",{texClass:h.TEXCLASS.OP,movesupsub:true}],bigcap:["22C2",{texClass:h.TEXCLASS.OP,movesupsub:true}],bigcup:["22C3",{texClass:h.TEXCLASS.OP,movesupsub:true}],"int":["222B",{texClass:h.TEXCLASS.OP}],intop:["222B",{texClass:h.TEXCLASS.OP,movesupsub:true,movablelimits:true}],iint:["222C",{texClass:h.TEXCLASS.OP}],iiint:["222D",{texClass:h.TEXCLASS.OP}],prod:["220F",{texClass:h.TEXCLASS.OP,movesupsub:true}],sum:["2211",{texClass:h.TEXCLASS.OP,movesupsub:true}],bigotimes:["2A02",{texClass:h.TEXCLASS.OP,movesupsub:true}],bigoplus:["2A01",{texClass:h.TEXCLASS.OP,movesupsub:true}],bigodot:["2A00",{texClass:h.TEXCLASS.OP,movesupsub:true}],oint:["222E",{texClass:h.TEXCLASS.OP}],bigsqcup:["2A06",{texClass:h.TEXCLASS.OP,movesupsub:true}],smallint:["222B",{largeop:false}],triangleleft:"25C3",triangleright:"25B9",bigtriangleup:"25B3",bigtriangledown:"25BD",wedge:"2227",land:"2227",vee:"2228",lor:"2228",cap:"2229",cup:"222A",ddagger:"2021",dagger:"2020",sqcap:"2293",sqcup:"2294",uplus:"228E",amalg:"2A3F",diamond:"22C4",bullet:"2219",wr:"2240",div:"00F7",odot:["2299",{largeop:false}],oslash:["2298",{largeop:false}],otimes:["2297",{largeop:false}],ominus:["2296",{largeop:false}],oplus:["2295",{largeop:false}],mp:"2213",pm:"00B1",circ:"2218",bigcirc:"25EF",setminus:["2216",{variantForm:true}],cdot:"22C5",ast:"2217",times:"00D7",star:"22C6",propto:"221D",sqsubseteq:"2291",sqsupseteq:"2292",parallel:"2225",mid:"2223",dashv:"22A3",vdash:"22A2",leq:"2264",le:"2264",geq:"2265",ge:"2265",lt:"003C",gt:"003E",succ:"227B",prec:"227A",approx:"2248",succeq:"2AB0",preceq:"2AAF",supset:"2283",subset:"2282",supseteq:"2287",subseteq:"2286","in":"2208",ni:"220B",notin:"2209",owns:"220B",gg:"226B",ll:"226A",sim:"223C",simeq:"2243",perp:"22A5",equiv:"2261",asymp:"224D",smile:"2323",frown:"2322",ne:"2260",neq:"2260",cong:"2245",doteq:"2250",bowtie:"22C8",models:"22A8",notChar:"29F8",Leftrightarrow:"21D4",Leftarrow:"21D0",Rightarrow:"21D2",leftrightarrow:"2194",leftarrow:"2190",gets:"2190",rightarrow:"2192",to:"2192",mapsto:"21A6",leftharpoonup:"21BC",leftharpoondown:"21BD",rightharpoonup:"21C0",rightharpoondown:"21C1",nearrow:"2197",searrow:"2198",nwarrow:"2196",swarrow:"2199",rightleftharpoons:"21CC",hookrightarrow:"21AA",hookleftarrow:"21A9",longleftarrow:"27F5",Longleftarrow:"27F8",longrightarrow:"27F6",Longrightarrow:"27F9",Longleftrightarrow:"27FA",longleftrightarrow:"27F7",longmapsto:"27FC",ldots:"2026",cdots:"22EF",vdots:"22EE",ddots:"22F1",dotsc:"2026",dotsb:"22EF",dotsm:"22EF",dotsi:"22EF",dotso:"2026",ldotp:["002E",{texClass:h.TEXCLASS.PUNCT}],cdotp:["22C5",{texClass:h.TEXCLASS.PUNCT}],colon:["003A",{texClass:h.TEXCLASS.PUNCT}]},mathchar7:{Gamma:"0393",Delta:"0394",Theta:"0398",Lambda:"039B",Xi:"039E",Pi:"03A0",Sigma:"03A3",Upsilon:"03A5",Phi:"03A6",Psi:"03A8",Omega:"03A9",_:"005F","#":"0023","$":"0024","%":"0025","&":"0026",And:"0026"},delimiter:{"(":"(",")":")","[":"[","]":"]","<":"27E8",">":"27E9","\\lt":"27E8","\\gt":"27E9","/":"/","|":["|",{texClass:h.TEXCLASS.ORD}],".":"","\\\\":"\\","\\lmoustache":"23B0","\\rmoustache":"23B1","\\lgroup":"27EE","\\rgroup":"27EF","\\arrowvert":"23D0","\\Arrowvert":"2016","\\bracevert":"23AA","\\Vert":["2225",{texClass:h.TEXCLASS.ORD}],"\\|":["2225",{texClass:h.TEXCLASS.ORD}],"\\vert":["|",{texClass:h.TEXCLASS.ORD}],"\\uparrow":"2191","\\downarrow":"2193","\\updownarrow":"2195","\\Uparrow":"21D1","\\Downarrow":"21D3","\\Updownarrow":"21D5","\\backslash":"\\","\\rangle":"27E9","\\langle":"27E8","\\rbrace":"}","\\lbrace":"{","\\}":"}","\\{":"{","\\rceil":"2309","\\lceil":"2308","\\rfloor":"230B","\\lfloor":"230A","\\lbrack":"[","\\rbrack":"]"},macros:{displaystyle:["SetStyle","D",true,0],textstyle:["SetStyle","T",false,0],scriptstyle:["SetStyle","S",false,1],scriptscriptstyle:["SetStyle","SS",false,2],rm:["SetFont",h.VARIANT.NORMAL],mit:["SetFont",h.VARIANT.ITALIC],oldstyle:["SetFont",h.VARIANT.OLDSTYLE],cal:["SetFont",h.VARIANT.CALIGRAPHIC],it:["SetFont","-tex-mathit"],bf:["SetFont",h.VARIANT.BOLD],bbFont:["SetFont",h.VARIANT.DOUBLESTRUCK],scr:["SetFont",h.VARIANT.SCRIPT],frak:["SetFont",h.VARIANT.FRAKTUR],sf:["SetFont",h.VARIANT.SANSSERIF],tt:["SetFont",h.VARIANT.MONOSPACE],tiny:["SetSize",0.5],Tiny:["SetSize",0.6],scriptsize:["SetSize",0.7],small:["SetSize",0.85],normalsize:["SetSize",1],large:["SetSize",1.2],Large:["SetSize",1.44],LARGE:["SetSize",1.73],huge:["SetSize",2.07],Huge:["SetSize",2.49],arcsin:["NamedFn"],arccos:["NamedFn"],arctan:["NamedFn"],arg:["NamedFn"],cos:["NamedFn"],cosh:["NamedFn"],cot:["NamedFn"],coth:["NamedFn"],csc:["NamedFn"],deg:["NamedFn"],det:"NamedOp",dim:["NamedFn"],exp:["NamedFn"],gcd:"NamedOp",hom:["NamedFn"],inf:"NamedOp",ker:["NamedFn"],lg:["NamedFn"],lim:"NamedOp",liminf:["NamedOp","lim&thinsp;inf"],limsup:["NamedOp","lim&thinsp;sup"],ln:["NamedFn"],log:["NamedFn"],max:"NamedOp",min:"NamedOp",Pr:"NamedOp",sec:["NamedFn"],sin:["NamedFn"],sinh:["NamedFn"],sup:"NamedOp",tan:["NamedFn"],tanh:["NamedFn"],limits:["Limits",1],nolimits:["Limits",0],overline:["UnderOver","00AF"],underline:["UnderOver","005F"],overbrace:["UnderOver","23DE",1],underbrace:["UnderOver","23DF",1],overrightarrow:["UnderOver","2192"],underrightarrow:["UnderOver","2192"],overleftarrow:["UnderOver","2190"],underleftarrow:["UnderOver","2190"],overleftrightarrow:["UnderOver","2194"],underleftrightarrow:["UnderOver","2194"],overset:"Overset",underset:"Underset",stackrel:["Macro","\\mathrel{\\mathop{#2}\\limits^{#1}}",2],over:"Over",overwithdelims:"Over",atop:"Over",atopwithdelims:"Over",above:"Over",abovewithdelims:"Over",brace:["Over","{","}"],brack:["Over","[","]"],choose:["Over","(",")"],frac:"Frac",sqrt:"Sqrt",root:"Root",uproot:["MoveRoot","upRoot"],leftroot:["MoveRoot","leftRoot"],left:"LeftRight",right:"LeftRight",middle:"Middle",llap:"Lap",rlap:"Lap",raise:"RaiseLower",lower:"RaiseLower",moveleft:"MoveLeftRight",moveright:"MoveLeftRight",",":["Spacer",h.LENGTH.THINMATHSPACE],":":["Spacer",h.LENGTH.MEDIUMMATHSPACE],">":["Spacer",h.LENGTH.MEDIUMMATHSPACE],";":["Spacer",h.LENGTH.THICKMATHSPACE],"!":["Spacer",h.LENGTH.NEGATIVETHINMATHSPACE],enspace:["Spacer",".5em"],quad:["Spacer","1em"],qquad:["Spacer","2em"],thinspace:["Spacer",h.LENGTH.THINMATHSPACE],negthinspace:["Spacer",h.LENGTH.NEGATIVETHINMATHSPACE],hskip:"Hskip",hspace:"Hskip",kern:"Hskip",mskip:"Hskip",mspace:"Hskip",mkern:"Hskip",Rule:["Rule"],Space:["Rule","blank"],big:["MakeBig",h.TEXCLASS.ORD,0.85],Big:["MakeBig",h.TEXCLASS.ORD,1.15],bigg:["MakeBig",h.TEXCLASS.ORD,1.45],Bigg:["MakeBig",h.TEXCLASS.ORD,1.75],bigl:["MakeBig",h.TEXCLASS.OPEN,0.85],Bigl:["MakeBig",h.TEXCLASS.OPEN,1.15],biggl:["MakeBig",h.TEXCLASS.OPEN,1.45],Biggl:["MakeBig",h.TEXCLASS.OPEN,1.75],bigr:["MakeBig",h.TEXCLASS.CLOSE,0.85],Bigr:["MakeBig",h.TEXCLASS.CLOSE,1.15],biggr:["MakeBig",h.TEXCLASS.CLOSE,1.45],Biggr:["MakeBig",h.TEXCLASS.CLOSE,1.75],bigm:["MakeBig",h.TEXCLASS.REL,0.85],Bigm:["MakeBig",h.TEXCLASS.REL,1.15],biggm:["MakeBig",h.TEXCLASS.REL,1.45],Biggm:["MakeBig",h.TEXCLASS.REL,1.75],mathord:["TeXAtom",h.TEXCLASS.ORD],mathop:["TeXAtom",h.TEXCLASS.OP],mathopen:["TeXAtom",h.TEXCLASS.OPEN],mathclose:["TeXAtom",h.TEXCLASS.CLOSE],mathbin:["TeXAtom",h.TEXCLASS.BIN],mathrel:["TeXAtom",h.TEXCLASS.REL],mathpunct:["TeXAtom",h.TEXCLASS.PUNCT],mathinner:["TeXAtom",h.TEXCLASS.INNER],vcenter:["TeXAtom",h.TEXCLASS.VCENTER],mathchoice:["Extension","mathchoice"],buildrel:"BuildRel",hbox:["HBox",0],text:"HBox",mbox:["HBox",0],fbox:"FBox",strut:"Strut",mathstrut:["Macro","\\vphantom{(}"],phantom:"Phantom",vphantom:["Phantom",1,0],hphantom:["Phantom",0,1],smash:"Smash",acute:["Accent","00B4"],grave:["Accent","0060"],ddot:["Accent","00A8"],tilde:["Accent","007E"],bar:["Accent","00AF"],breve:["Accent","02D8"],check:["Accent","02C7"],hat:["Accent","005E"],vec:["Accent","2192"],dot:["Accent","02D9"],widetilde:["Accent","007E",1],widehat:["Accent","005E",1],matrix:"Matrix",array:"Matrix",pmatrix:["Matrix","(",")"],cases:["Matrix","{","","left left",null,".1em",null,true],eqalign:["Matrix",null,null,"right left",h.LENGTH.THICKMATHSPACE,".5em","D"],displaylines:["Matrix",null,null,"center",null,".5em","D"],cr:"Cr","\\":"CrLaTeX",newline:"Cr",hline:["HLine","solid"],hdashline:["HLine","dashed"],eqalignno:["Matrix",null,null,"right left right",h.LENGTH.THICKMATHSPACE+" 3em",".5em","D"],leqalignno:["Matrix",null,null,"right left right",h.LENGTH.THICKMATHSPACE+" 3em",".5em","D"],bmod:["Macro","\\mathbin{\\mmlToken{mo}{mod}}"],pmod:["Macro","\\pod{\\mmlToken{mi}{mod}\\kern 6mu #1}",1],mod:["Macro","\\mathchoice{\\kern18mu}{\\kern12mu}{\\kern12mu}{\\kern12mu}\\mmlToken{mi}{mod}\\,\\,#1",1],pod:["Macro","\\mathchoice{\\kern18mu}{\\kern8mu}{\\kern8mu}{\\kern8mu}(#1)",1],iff:["Macro","\\;\\Longleftrightarrow\\;"],skew:["Macro","{{#2{#3\\mkern#1mu}\\mkern-#1mu}{}}",3],mathcal:["Macro","{\\cal #1}",1],mathscr:["Macro","{\\scr #1}",1],mathrm:["Macro","{\\rm #1}",1],mathbf:["Macro","{\\bf #1}",1],mathbb:["Macro","{\\bbFont #1}",1],Bbb:["Macro","{\\bbFont #1}",1],mathit:["Macro","{\\it #1}",1],mathfrak:["Macro","{\\frak #1}",1],mathsf:["Macro","{\\sf #1}",1],mathtt:["Macro","{\\tt #1}",1],textrm:["Macro","\\mathord{\\rm\\text{#1}}",1],textit:["Macro","\\mathord{\\it{\\text{#1}}}",1],textbf:["Macro","\\mathord{\\bf{\\text{#1}}}",1],pmb:["Macro","\\rlap{#1}\\kern1px{#1}",1],TeX:["Macro","T\\kern-.14em\\lower.5ex{E}\\kern-.115em X"],LaTeX:["Macro","L\\kern-.325em\\raise.21em{\\scriptstyle{A}}\\kern-.17em\\TeX"]," ":["Macro","\\text{ }"],not:"Not",dots:"Dots",space:"Tilde",begin:"Begin",end:"End",newcommand:["Extension","newcommand"],renewcommand:["Extension","newcommand"],newenvironment:["Extension","newcommand"],renewenvironment:["Extension","newcommand"],def:["Extension","newcommand"],let:["Extension","newcommand"],verb:["Extension","verb"],boldsymbol:["Extension","boldsymbol"],tag:["Extension","AMSmath"],notag:["Extension","AMSmath"],label:["Extension","AMSmath"],ref:["Extension","AMSmath"],eqref:["Extension","AMSmath"],nonumber:["Macro","\\notag"],unicode:["Extension","unicode"],color:"Color",href:["Extension","HTML"],"class":["Extension","HTML"],style:["Extension","HTML"],cssId:["Extension","HTML"],bbox:["Extension","bbox"],mmlToken:"MmlToken",require:"Require"},environment:{array:["AlignedArray"],matrix:["Array",null,null,null,"c"],pmatrix:["Array",null,"(",")","c"],bmatrix:["Array",null,"[","]","c"],Bmatrix:["Array",null,"\\{","\\}","c"],vmatrix:["Array",null,"\\vert","\\vert","c"],Vmatrix:["Array",null,"\\Vert","\\Vert","c"],cases:["Array",null,"\\{",".","ll",null,".1em"],equation:[null,"Equation"],"equation*":[null,"Equation"],eqnarray:["ExtensionEnv",null,"AMSmath"],"eqnarray*":["ExtensionEnv",null,"AMSmath"],align:["ExtensionEnv",null,"AMSmath"],"align*":["ExtensionEnv",null,"AMSmath"],aligned:["ExtensionEnv",null,"AMSmath"],multline:["ExtensionEnv",null,"AMSmath"],"multline*":["ExtensionEnv",null,"AMSmath"],split:["ExtensionEnv",null,"AMSmath"],gather:["ExtensionEnv",null,"AMSmath"],"gather*":["ExtensionEnv",null,"AMSmath"],gathered:["ExtensionEnv",null,"AMSmath"],alignat:["ExtensionEnv",null,"AMSmath"],"alignat*":["ExtensionEnv",null,"AMSmath"],alignedat:["ExtensionEnv",null,"AMSmath"]},p_height:1.2/0.85});if(this.config.Macros){var k=this.config.Macros;for(var l in k){if(k.hasOwnProperty(l)){if(typeof(k[l])==="string"){f.macros[l]=["Macro",k[l]]}else{f.macros[l]=["Macro"].concat(k[l])}f.macros[l].isUser=true}}}};var a=MathJax.Object.Subclass({Init:function(l,m){this.string=l;this.i=0;this.macroCount=0;var k;if(m){k={};for(var n in m){if(m.hasOwnProperty(n)){k[n]=m[n]}}}this.stack=d.Stack(k,!!m);this.Parse();this.Push(b.stop())},Parse:function(){var l,k;while(this.i<this.string.length){l=this.string.charAt(this.i++);k=l.charCodeAt(0);if(k>=55296&&k<56320){l+=this.string.charAt(this.i++)}if(f.special[l]){this[f.special[l]](l)}else{if(f.letter.test(l)){this.Variable(l)}else{if(f.digit.test(l)){this.Number(l)}else{this.Other(l)}}}}},Push:function(){this.stack.Push.apply(this.stack,arguments)},mml:function(){if(this.stack.Top().type!=="mml"){return null}return this.stack.Top().data[0]},mmlToken:function(k){return k},ControlSequence:function(n){var k=this.GetCS(),m=this.csFindMacro(k);if(m){if(!(m instanceof Array)){m=[m]}var l=m[0];if(!(l instanceof Function)){l=this[l]}l.apply(this,[n+k].concat(m.slice(1)))}else{if(f.mathchar0mi[k]){this.csMathchar0mi(k,f.mathchar0mi[k])}else{if(f.mathchar0mo[k]){this.csMathchar0mo(k,f.mathchar0mo[k])}else{if(f.mathchar7[k]){this.csMathchar7(k,f.mathchar7[k])}else{if(f.delimiter["\\"+k]!=null){this.csDelimiter(k,f.delimiter["\\"+k])}else{this.csUndefined(n+k)}}}}}},csFindMacro:function(k){return f.macros[k]},csMathchar0mi:function(k,m){var l={mathvariant:h.VARIANT.ITALIC};if(m instanceof Array){l=m[1];m=m[0]}this.Push(this.mmlToken(h.mi(h.entity("#x"+m)).With(l)))},csMathchar0mo:function(k,m){var l={stretchy:false};if(m instanceof Array){l=m[1];l.stretchy=false;m=m[0]}this.Push(this.mmlToken(h.mo(h.entity("#x"+m)).With(l)))},csMathchar7:function(k,m){var l={mathvariant:h.VARIANT.NORMAL};if(m instanceof Array){l=m[1];m=m[0]}if(this.stack.env.font){l.mathvariant=this.stack.env.font}this.Push(this.mmlToken(h.mi(h.entity("#x"+m)).With(l)))},csDelimiter:function(k,m){var l={};if(m instanceof Array){l=m[1];m=m[0]}if(m.length===4){m=h.entity("#x"+m)}else{m=h.chars(m)}this.Push(this.mmlToken(h.mo(m).With({fence:false,stretchy:false}).With(l)))},csUndefined:function(k){d.Error("Undefined control sequence "+k)},Variable:function(l){var k={};if(this.stack.env.font){k.mathvariant=this.stack.env.font}this.Push(this.mmlToken(h.mi(h.chars(l)).With(k)))},Number:function(m){var k,l=this.string.slice(this.i-1).match(f.number);if(l){k=h.mn(l[0].replace(/[{}]/g,""));this.i+=l[0].length-1}else{k=h.mo(h.chars(m))}if(this.stack.env.font){k.mathvariant=this.stack.env.font}this.Push(this.mmlToken(k))},Open:function(k){this.Push(b.open())},Close:function(k){this.Push(b.close())},Tilde:function(k){this.Push(h.mtext(h.chars(g)))},Space:function(k){},Superscript:function(o){if(this.GetNext().match(/\d/)){this.string=this.string.substr(0,this.i+1)+" "+this.string.substr(this.i+1)}var k,n,l,m=this.stack.Top();if(m.type==="prime"){l=m.data[0];n=m.data[1];this.stack.Pop()}else{l=this.stack.Prev();if(!l){l=h.mi("")}}if(l.isEmbellishedWrapper){l=l.data[0].data[0]}if(l.type==="msubsup"){if(l.data[l.sup]){d.Error("Double exponent: use braces to clarify")}k=l.sup}else{if(l.movesupsub){if(l.type!=="munderover"||l.data[l.over]){if(l.movablelimits&&l.isa(h.mi)){l=this.mi2mo(l)}l=h.munderover(l,null,null).With({movesupsub:true})}k=l.over}else{l=h.msubsup(l,null,null);k=l.sup}}this.Push(b.subsup(l).With({position:k,primes:n}))},Subscript:function(o){if(this.GetNext().match(/\d/)){this.string=this.string.substr(0,this.i+1)+" "+this.string.substr(this.i+1)}var k,n,l,m=this.stack.Top();if(m.type==="prime"){l=m.data[0];n=m.data[1];this.stack.Pop()}else{l=this.stack.Prev();if(!l){l=h.mi("")}}if(l.isEmbellishedWrapper){l=l.data[0].data[0]}if(l.type==="msubsup"){if(l.data[l.sub]){d.Error("Double subscripts: use braces to clarify")}k=l.sub}else{if(l.movesupsub){if(l.type!=="munderover"||l.data[l.under]){if(l.movablelimits&&l.isa(h.mi)){l=this.mi2mo(l)}l=h.munderover(l,null,null).With({movesupsub:true})}k=l.under}else{l=h.msubsup(l,null,null);k=l.sub}}this.Push(b.subsup(l).With({position:k,primes:n}))},PRIME:"\u2032",SMARTQUOTE:"\u2019",Prime:function(m){var l=this.stack.Prev();if(!l){l=h.mi()}if(l.type==="msubsup"&&l.data[l.sup]){d.Error("Prime causes double exponent: use braces to clarify")}var k="";this.i--;do{k+=this.PRIME;this.i++,m=this.GetNext()}while(m==="'"||m===this.SMARTQUOTE);k=["","\u2032","\u2033","\u2034","\u2057"][k.length]||k;this.Push(b.prime(l,this.mmlToken(h.mo(k))))},mi2mo:function(k){var l=h.mo();l.Append.apply(l,k.data);var m;for(m in l.defaults){if(l.defaults.hasOwnProperty(m)&&k[m]!=null){l[m]=k[m]}}for(m in h.copyAttributes){if(h.copyAttributes.hasOwnProperty(m)&&k[m]!=null){l[m]=k[m]}}return l},Comment:function(k){while(this.i<this.string.length&&this.string.charAt(this.i)!="\n"){this.i++}},Hash:function(k){d.Error("You can't use 'macro parameter character #' in math mode")},Other:function(m){var l={stretchy:false},k;if(this.stack.env.font){l.mathvariant=this.stack.env.font}if(f.remap[m]){m=f.remap[m];if(m instanceof Array){l=m[1];m=m[0]}k=h.mo(h.entity("#x"+m)).With(l)}else{k=h.mo(m).With(l)}if(k.autoDefault("texClass",true)==""){k=h.TeXAtom(k)}this.Push(this.mmlToken(k))},SetFont:function(l,k){this.stack.env.font=k},SetStyle:function(l,k,m,n){this.stack.env.style=k;this.stack.env.level=n;this.Push(b.style().With({styles:{displaystyle:m,scriptlevel:n}}))},SetSize:function(k,l){this.stack.env.size=l;this.Push(b.style().With({styles:{mathsize:l+"em"}}))},Color:function(m){var l=this.GetArgument(m);var k=this.stack.env.color;this.stack.env.color=l;var n=this.ParseArg(m);if(k){this.stack.env.color}else{delete this.stack.env.color}this.Push(h.mstyle(n).With({mathcolor:l}))},Spacer:function(k,l){this.Push(h.mspace().With({width:l,mathsize:h.SIZE.NORMAL,scriptlevel:0}))},LeftRight:function(k){this.Push(b[k.substr(1)]().With({delim:this.GetDelimiter(k)}))},Middle:function(k){var l=this.GetDelimiter(k);if(this.stack.Top().type!=="left"){d.Error(k+" must be within \\left and \\right")}this.Push(h.mo(l).With({stretchy:true}))},NamedFn:function(l,m){if(!m){m=l.substr(1)}var k=h.mi(m).With({texClass:h.TEXCLASS.OP});this.Push(b.fn(this.mmlToken(k)))},NamedOp:function(l,m){if(!m){m=l.substr(1)}m=m.replace(/&thinsp;/,"\u2006");var k=h.mo(m).With({movablelimits:true,movesupsub:true,form:h.FORM.PREFIX,texClass:h.TEXCLASS.OP});k.useMMLspacing&=~k.SPACE_ATTR.form;this.Push(this.mmlToken(k))},Limits:function(l,k){var m=this.stack.Prev("nopop");if(!m||m.texClass!==h.TEXCLASS.OP){d.Error(l+" is allowed only on operators")}m.movesupsub=(k?true:false);m.movablelimits=false},Over:function(m,l,n){var k=b.over().With({name:m});if(l||n){k.open=l;k.close=n}else{if(m.match(/withdelims$/)){k.open=this.GetDelimiter(m);k.close=this.GetDelimiter(m)}}if(m.match(/^\\above/)){k.thickness=this.GetDimen(m)}else{if(m.match(/^\\atop/)||l||n){k.thickness=0}}this.Push(k)},Frac:function(l){var k=this.ParseArg(l);var m=this.ParseArg(l);this.Push(h.mfrac(k,m))},Sqrt:function(m){var o=this.GetBrackets(m),k=this.GetArgument(m);if(k==="\\frac"){k+="{"+this.GetArgument(k)+"}{"+this.GetArgument(k)+"}"}var l=d.Parse(k,this.stack.env).mml();if(!o){l=h.msqrt.apply(h,l.array())}else{l=h.mroot(l,this.parseRoot(o))}this.Push(l)},Root:function(l){var m=this.GetUpTo(l,"\\of");var k=this.ParseArg(l);this.Push(h.mroot(k,this.parseRoot(m)))},parseRoot:function(p){var l=this.stack.env,k=l.inRoot;l.inRoot=true;var o=d.Parse(p,l);p=o.mml();var m=o.stack.global;if(m.leftRoot||m.upRoot){p=h.mpadded(p);if(m.leftRoot){p.width=m.leftRoot}if(m.upRoot){p.voffset=m.upRoot;p.height=m.upRoot}}l.inRoot=k;return p},MoveRoot:function(k,m){if(!this.stack.env.inRoot){d.Error(k+" can appear only within a root")}if(this.stack.global[m]){d.Error("Multiple use of "+k)}var l=this.GetArgument(k);if(!l.match(/-?[0-9]+/)){d.Error("The argument to "+k+" must be an integer")}l=(l/15)+"em";if(l.substr(0,1)!=="-"){l="+"+l}this.stack.global[m]=l},Accent:function(m,k,p){var o=this.ParseArg(m);var n={accent:true};if(this.stack.env.font){n.mathvariant=this.stack.env.font}var l=this.mmlToken(h.mo(h.entity("#x"+k)).With(n));l.stretchy=(p?true:false);this.Push(h.TeXAtom(h.munderover(o,null,l).With({accent:true})))},UnderOver:function(m,p,k){var o={o:"over",u:"under"}[m.charAt(1)];var n=this.ParseArg(m);if(n.Get("movablelimits")){n.movablelimits=false}var l=h.munderover(n,null,null);if(k){l.movesupsub=true}l.data[l[o]]=this.mmlToken(h.mo(h.entity("#x"+p)).With({stretchy:true,accent:(o=="under")}));this.Push(l)},Overset:function(k){var m=this.ParseArg(k),l=this.ParseArg(k);this.Push(h.mover(l,m))},Underset:function(k){var m=this.ParseArg(k),l=this.ParseArg(k);this.Push(h.munder(l,m))},TeXAtom:function(n,p){var o={texClass:p},m;if(p==h.TEXCLASS.OP){o.movesupsub=o.movablelimits=true;var k=this.GetArgument(n);var l=k.match(/^\s*\\rm\s+([a-zA-Z0-9 ]+)$/);if(l){o.mathvariant=h.VARIANT.NORMAL;m=b.fn(this.mmlToken(h.mi(l[1]).With(o)))}else{m=b.fn(h.TeXAtom(d.Parse(k,this.stack.env).mml()).With(o))}}else{m=h.TeXAtom(this.ParseArg(n)).With(o)}this.Push(m)},MmlToken:function(m){var n=this.GetArgument(m),k=this.GetBrackets(m,"").replace(/^\s+/,""),p=this.GetArgument(m),o={attrNames:[]},l;if(!h[n]||!h[n].prototype.isToken){d.Error(n+" is not a token element")}while(k!==""){l=k.match(/^([a-z]+)\s*=\s*('[^']*'|"[^"]*"|[^ ]*)\s*/i);if(!l){d.Error("Invalid MathML attribute: "+k)}if(!h[n].prototype.defaults[l[1]]&&!this.MmlTokenAllow[l[1]]){d.Error(l[1]+" is not a recognized attribute for "+n)}o[l[1]]=l[2].replace(/^(['"])(.*)\1$/,"$2");o.attrNames.push(l[1]);k=k.substr(l[0].length)}this.Push(this.mmlToken(h[n](p).With(o)))},MmlTokenAllow:{fontfamily:1,fontsize:1,fontweight:1,fontstyle:1,color:1,background:1,id:1,"class":1,href:1,style:1},Strut:function(k){this.Push(h.mpadded(h.mrow()).With({height:"8.6pt",depth:"3pt",width:0}))},Phantom:function(l,k,m){var n=h.mphantom(this.ParseArg(l));if(k||m){n=h.mpadded(n);if(m){n.height=n.depth=0}if(k){n.width=0}}this.Push(h.TeXAtom(n))},Smash:function(m){var l=this.trimSpaces(this.GetBrackets(m,""));var k=h.mpadded(this.ParseArg(m));switch(l){case"b":k.depth=0;break;case"t":k.height=0;break;default:k.height=k.depth=0}this.Push(h.TeXAtom(k))},Lap:function(l){var k=h.mpadded(this.ParseArg(l)).With({width:0});if(l==="\\llap"){k.lspace="-1 width"}this.Push(h.TeXAtom(k))},RaiseLower:function(k){var l=this.GetDimen(k);var m=b.position().With({name:k,move:"vertical"});if(l.charAt(0)==="-"){l=l.slice(1);k={raise:"\\lower",lower:"\\raise"}[k.substr(1)]}if(k==="\\lower"){m.dh="-"+l;m.dd="+"+l}else{m.dh="+"+l;m.dd="-"+l}this.Push(m)},MoveLeftRight:function(k){var n=this.GetDimen(k);var m=(n.charAt(0)==="-"?n.slice(1):"-"+n);if(k==="\\moveleft"){var l=n;n=m;m=l}this.Push(b.position().With({name:k,move:"horizontal",left:h.mspace().With({width:n,mathsize:h.SIZE.NORMAL}),right:h.mspace().With({width:m,mathsize:h.SIZE.NORMAL})}))},Hskip:function(k){this.Push(h.mspace().With({width:this.GetDimen(k),mathsize:h.SIZE.NORMAL}))},Rule:function(m,o){var k=this.GetDimen(m),n=this.GetDimen(m),q=this.GetDimen(m);var l,p={width:k,height:n,depth:q};if(o!=="blank"){if(parseFloat(k)&&parseFloat(n)+parseFloat(q)){p.mathbackground=(this.stack.env.color||"black")}l=h.mpadded(h.mrow()).With(p)}else{l=h.mspace().With(p)}this.Push(l)},MakeBig:function(k,n,l){l*=f.p_height;l=String(l).replace(/(\.\d\d\d).+/,"$1")+"em";var m=this.GetDelimiter(k);this.Push(h.TeXAtom(h.mo(m).With({minsize:l,maxsize:l,scriptlevel:0,fence:true,stretchy:true,symmetric:true})).With({texClass:n}))},BuildRel:function(k){var l=this.ParseUpTo(k,"\\over");var m=this.ParseArg(k);this.Push(h.TeXAtom(h.munderover(m,null,l)).With({mclass:h.TEXCLASS.REL}))},HBox:function(k,l){this.Push.apply(this,this.InternalMath(this.GetArgument(k),l))},FBox:function(k){this.Push(h.menclose.apply(h,this.InternalMath(this.GetArgument(k))).With({notation:"box"}))},Not:function(k){this.Push(b.not())},Dots:function(k){this.Push(b.dots().With({ldots:this.mmlToken(h.mo(h.entity("#x2026")).With({stretchy:false})),cdots:this.mmlToken(h.mo(h.entity("#x22EF")).With({stretchy:false}))}))},Require:function(k){var l=this.GetArgument(k).replace(/.*\//,"").replace(/[^a-z0-9_.-]/ig,"");this.Extension(null,l)},Extension:function(k,l,m){if(k&&!typeof(k)==="string"){k=k.name}l=d.extensionDir+"/"+l;if(!l.match(/\.js$/)){l+=".js"}if(!i.loaded[i.fileURL(l)]){if(k!=null){delete f[m||"macros"][k.replace(/^\\/,"")]}c.RestartAfter(i.Require(l))}},Macro:function(m,p,o,q){if(o){var l=[];if(q!=null){var k=this.GetBrackets(m);l.push(k==null?q:k)}for(var n=l.length;n<o;n++){l.push(this.GetArgument(m))}p=this.SubstituteArgs(l,p)}this.string=this.AddArgs(p,this.string.slice(this.i));this.i=0;if(++this.macroCount>d.config.MAXMACROS){d.Error("MathJax maximum macro substitution count exceeded; is there a recursive macro call?")}},Matrix:function(l,n,s,p,r,m,k,t){var q=this.GetNext();if(q===""){d.Error("Missing argument for "+l)}if(q==="{"){this.i++}else{this.string=q+"}"+this.string.slice(this.i+1);this.i=0}var o=b.array().With({requireClose:true,arraydef:{rowspacing:(m||"4pt"),columnspacing:(r||"1em")}});if(t){o.isCases=true}if(n||s){o.open=n;o.close=s}if(k==="D"){o.arraydef.displaystyle=true}if(p!=null){o.arraydef.columnalign=p}this.Push(o)},Entry:function(n){this.Push(b.cell().With({isEntry:true,name:n}));if(this.stack.Top().isCases){var l=this.string;var q=0,o=this.i,k=l.length;while(o<k){var r=l.charAt(o);if(r==="{"){q++;o++}else{if(r==="}"){if(q===0){k=0}else{q--;o++}}else{if(r==="&"&&q===0){d.Error("Extra alignment tab in \\cases text")}else{if(r==="\\"){if(l.substr(o).match(/^((\\cr)[^a-zA-Z]|\\\\)/)){k=0}else{o+=2}}else{o++}}}}}var p=l.substr(this.i,o-this.i);if(!p.match(/^\s*\\text[^a-zA-Z]/)){this.Push.apply(this,this.InternalMath(p));this.i=o}}},Cr:function(k){this.Push(b.cell().With({isCR:true,name:k}))},CrLaTeX:function(k){var o;if(this.string.charAt(this.i)==="["){o=this.GetBrackets(k,"").replace(/ /g,"");if(o&&!o.match(/^((-?(\.\d+|\d+(\.\d*)?))(pt|em|ex|mu|mm|cm|in|pc))$/)){d.Error("Bracket argument to "+k+" must be a dimension")}}this.Push(b.cell().With({isCR:true,name:k,linebreak:true}));var m=this.stack.Top();if(m.isa(b.array)){if(o&&m.arraydef.rowspacing){var l=m.arraydef.rowspacing.split(/ /);if(!m.rowspacing){m.rowspacing=this.dimen2em(l[0])}while(l.length<m.table.length){l.push(this.Em(m.rowspacing))}l[m.table.length-1]=this.Em(Math.max(0,m.rowspacing+this.dimen2em(o)));m.arraydef.rowspacing=l.join(" ")}}else{if(o){this.Push(h.mspace().With({depth:o}))}this.Push(h.mo().With({linebreak:h.LINEBREAK.NEWLINE}))}},emPerInch:7.2,dimen2em:function(o){var l=o.match(/^(-?(?:\.\d+|\d+(?:\.\d*)?))(pt|em|ex|mu|pc|in|mm|cm)/);var k=parseFloat(l[1]||"1"),n=l[2];if(n==="em"){return k}if(n==="ex"){return k*0.43}if(n==="pt"){return k/10}if(n==="pc"){return k*1.2}if(n==="in"){return k*this.emPerInch}if(n==="cm"){return k*this.emPerInch/2.54}if(n==="mm"){return k*this.emPerInch/25.4}if(n==="mu"){return k/18}return 0},Em:function(k){if(Math.abs(k)<0.0006){return"0em"}return k.toFixed(3).replace(/\.?0+$/,"")+"em"},HLine:function(l,m){if(m==null){m="solid"}var n=this.stack.Top();if(!n.isa(b.array)||n.data.length){d.Error("Misplaced "+l)}if(n.table.length==0){n.frame.push("top")}else{var k=(n.arraydef.rowlines?n.arraydef.rowlines.split(/ /):[]);while(k.length<n.table.length){k.push("none")}k[n.table.length-1]=m;n.arraydef.rowlines=k.join(" ")}},Begin:function(l){var m=this.GetArgument(l);if(m.match(/[^a-z*]/i)){d.Error('Invalid environment name "'+m+'"')}var n=this.envFindName(m);if(!n){d.Error('Unknown environment "'+m+'"')}if(++this.macroCount>d.config.MAXMACROS){d.Error("MathJax maximum substitution count exceeded; is there a recursive latex environment?")}if(!(n instanceof Array)){n=[n]}var k=b.begin().With({name:m,end:n[1],parse:this});if(n[0]&&this[n[0]]){k=this[n[0]].apply(this,[k].concat(n.slice(2)))}this.Push(k)},End:function(k){this.Push(b.end().With({name:this.GetArgument(k)}))},envFindName:function(k){return f.environment[k]},Equation:function(k,l){return l},ExtensionEnv:function(l,k){this.Extension(l.name,k,"environment")},Array:function(l,n,s,q,r,m,k,o){if(!q){q=this.GetArgument("\\begin{"+l.name+"}")}var t=("c"+q).replace(/[^clr|:]/g,"").replace(/[^|:]([|:])+/g,"$1");q=q.replace(/[^clr]/g,"").split("").join(" ");q=q.replace(/l/g,"left").replace(/r/g,"right").replace(/c/g,"center");var p=b.array().With({arraydef:{columnalign:q,columnspacing:(r||"1em"),rowspacing:(m||"4pt")}});if(t.match(/[|:]/)){if(t.charAt(0).match(/[|:]/)){p.frame.push("left");p.frame.dashed=t.charAt(0)===":"}if(t.charAt(t.length-1).match(/[|:]/)){p.frame.push("right")}t=t.substr(1,t.length-2);p.arraydef.columnlines=t.split("").join(" ").replace(/[^|: ]/g,"none").replace(/\|/g,"solid").replace(/:/g,"dashed")}if(n){p.open=this.convertDelimiter(n)}if(s){p.close=this.convertDelimiter(s)}if(k==="D"){p.arraydef.displaystyle=true}if(k==="S"){p.arraydef.scriptlevel=1}if(o){p.arraydef.useHeight=false}this.Push(l);return p},AlignedArray:function(k){var l=this.GetBrackets("\\begin{"+k.name+"}");return this.setArrayAlign(this.Array.apply(this,arguments),l)},setArrayAlign:function(l,k){k=this.trimSpaces(k||"");if(k==="t"){l.arraydef.align="baseline 1"}else{if(k==="b"){l.arraydef.align="baseline -1"}else{if(k==="c"){l.arraydef.align="center"}else{if(k){l.arraydef.align=k}}}}return l},convertDelimiter:function(k){if(k){k=f.delimiter[k]}if(k==null){return null}if(k instanceof Array){k=k[0]}if(k.length===4){k=String.fromCharCode(parseInt(k,16))}return k},trimSpaces:function(k){if(typeof(k)!="string"){return k}return k.replace(/^\s+|\s+$/g,"")},nextIsSpace:function(){return this.string.charAt(this.i).match(/[ \n\r\t]/)},GetNext:function(){while(this.nextIsSpace()){this.i++}return this.string.charAt(this.i)},GetCS:function(){var k=this.string.slice(this.i).match(/^([a-z]+|.) ?/i);if(k){this.i+=k[1].length;return k[1]}else{this.i++;return" "}},GetArgument:function(l,m){switch(this.GetNext()){case"":if(!m){d.Error("Missing argument for "+l)}return null;case"}":if(!m){d.Error("Extra close brace or missing open brace")}return null;case"\\":this.i++;return"\\"+this.GetCS();case"{":var k=++this.i,n=1;while(this.i<this.string.length){switch(this.string.charAt(this.i++)){case"\\":this.i++;break;case"{":n++;break;case"}":if(n==0){d.Error("Extra close brace")}if(--n==0){return this.string.slice(k,this.i-1)}break}}d.Error("Missing close brace");break}return this.string.charAt(this.i++)},GetBrackets:function(l,n){if(this.GetNext()!="["){return n}var k=++this.i,m=0;while(this.i<this.string.length){switch(this.string.charAt(this.i++)){case"{":m++;break;case"\\":this.i++;break;case"}":if(m--<=0){d.Error("Extra close brace while looking for ']'")}break;case"]":if(m==0){return this.string.slice(k,this.i-1)}break}}d.Error("Couldn't find closing ']' for argument to "+l)},GetDelimiter:function(k){while(this.nextIsSpace()){this.i++}var l=this.string.charAt(this.i);if(this.i<this.string.length){this.i++;if(l=="\\"){l+=this.GetCS(k)}if(f.delimiter[l]!=null){return this.convertDelimiter(l)}}d.Error("Missing or unrecognized delimiter for "+k)},GetDimen:function(l){var m;if(this.nextIsSpace()){this.i++}if(this.string.charAt(this.i)=="{"){m=this.GetArgument(l);if(m.match(/^\s*([-+]?(\.\d+|\d+(\.\d*)?))\s*(pt|em|ex|mu|px|mm|cm|in|pc)\s*$/)){return m.replace(/ /g,"")}}else{m=this.string.slice(this.i);var k=m.match(/^\s*(([-+]?(\.\d+|\d+(\.\d*)?))\s*(pt|em|ex|mu|px|mm|cm|in|pc)) ?/);if(k){this.i+=k[0].length;return k[1].replace(/ /g,"")}}d.Error("Missing dimension or its units for "+l)},GetUpTo:function(n,o){while(this.nextIsSpace()){this.i++}var m=this.i,l,q,p=0;while(this.i<this.string.length){l=this.i;q=this.string.charAt(this.i++);switch(q){case"\\":q+=this.GetCS();break;case"{":p++;break;case"}":if(p==0){d.Error("Extra close brace while looking for "+o)}p--;break}if(p==0&&q==o){return this.string.slice(m,l)}}d.Error("Couldn't find "+o+" for "+n)},ParseArg:function(k){return d.Parse(this.GetArgument(k),this.stack.env).mml()},ParseUpTo:function(k,l){return d.Parse(this.GetUpTo(k,l),this.stack.env).mml()},InternalMath:function(q,s){var p={displaystyle:false};if(s!=null){p.scriptlevel=s}if(this.stack.env.font){p.mathvariant=this.stack.env.font}if(!q.match(/\$|\\\(|\\(eq)?ref\s*\{/)){return[this.InternalText(q,p)]}var o=0,l=0,r,n="";var m=[];while(o<q.length){r=q.charAt(o++);if(r==="$"){if(n==="$"){m.push(h.TeXAtom(d.Parse(q.slice(l,o-1),{}).mml().With(p)));n="";l=o}else{if(n===""){if(l<o-1){m.push(this.InternalText(q.slice(l,o-1),p))}n="$";l=o}}}else{if(r==="}"&&n==="}"){m.push(h.TeXAtom(d.Parse(q.slice(l,o),{}).mml().With(p)));n="";l=o}else{if(r==="\\"){if(n===""&&q.substr(o).match(/^(eq)?ref\s*\{/)){if(l<o-1){m.push(this.InternalText(q.slice(l,o-1),p))}n="}";l=o-1}else{r=q.charAt(o++);if(r==="("&&n===""){if(l<o-2){m.push(this.InternalText(q.slice(l,o-2),p))}n=")";l=o}else{if(r===")"&&n===")"){m.push(h.TeXAtom(d.Parse(q.slice(l,o-2),{}).mml().With(p)));n="";l=o}}}}}}}if(n!==""){d.Error("Math not terminated in text box")}if(l<q.length){m.push(this.InternalText(q.slice(l),p))}return m},InternalText:function(l,k){l=l.replace(/^\s+/,g).replace(/\s+$/,g);return h.mtext(h.chars(l)).With(k)},SubstituteArgs:function(l,k){var o="";var n="";var p;var m=0;while(m<k.length){p=k.charAt(m++);if(p==="\\"){o+=p+k.charAt(m++)}else{if(p==="#"){p=k.charAt(m++);if(p==="#"){o+=p}else{if(!p.match(/[1-9]/)||p>l.length){d.Error("Illegal macro parameter reference")}n=this.AddArgs(this.AddArgs(n,o),l[p-1]);o=""}}else{o+=p}}}return this.AddArgs(n,o)},AddArgs:function(l,k){if(k.match(/^[a-z]/i)&&l.match(/(^|[^\\])(\\\\)*\\[a-z]+$/i)){l+=" "}if(l.length+k.length>d.config.MAXBUFFER){d.Error("MathJax internal buffer size exceeded; is there a recursive macro call?")}return l+k}});d.Augment({Stack:e,Parse:a,Definitions:f,Startup:j,config:{MAXMACROS:10000,MAXBUFFER:5*1024},sourceMenuTitle:"TeX Commands",prefilterHooks:MathJax.Callback.Hooks(true),postfilterHooks:MathJax.Callback.Hooks(true),Config:function(){this.SUPER(arguments).Config.apply(this,arguments);if(this.config.equationNumbers.autoNumber!=="none"){if(!this.config.extensions){this.config.extensions=[]}this.config.extensions.push("AMSmath.js")}},Translate:function(k){var l,m=false,o=MathJax.HTML.getScript(k);var q=(k.type.replace(/\n/g," ").match(/(;|\s|\n)mode\s*=\s*display(;|\s|\n|$)/)!=null);var p={math:o,display:q,script:k};this.prefilterHooks.Execute(p);o=p.math;try{l=d.Parse(o).mml()}catch(n){if(!n.texError){throw n}l=this.formatError(n,o,q,k);m=true}if(l.inferred){l=h.apply(MathJax.ElementJax,l.data)}else{l=h(l)}if(q){l.root.display="block"}if(m){l.texError=true}p.math=l;this.postfilterHooks.Execute(p);return p.math},prefilterMath:function(l,m,k){return l},postfilterMath:function(l,m,k){this.combineRelations(l.root);return l},formatError:function(n,m,o,k){var l=n.message.replace(/\n.*/,"");c.signal.Post(["TeX Jax - parse error",l,m,o,k]);return h.merror(l)},Error:function(k){throw c.Insert(Error(k),{texError:true})},Macro:function(k,l,m){f.macros[k]=["Macro"].concat([].slice.call(arguments,1));f.macros[k].isUser=true},combineRelations:function(o){var p,k,n,l;for(p=0,k=o.data.length;p<k;p++){if(o.data[p]){if(o.isa(h.mrow)){while(p+1<k&&(n=o.data[p])&&(l=o.data[p+1])&&n.isa(h.mo)&&l.isa(h.mo)&&n.Get("texClass")===h.TEXCLASS.REL&&l.Get("texClass")===h.TEXCLASS.REL){if(n.variantForm==l.variantForm&&n.Get("mathvariant")==l.Get("mathvariant")&&n.style==l.style&&n["class"]==l["class"]&&!n.id&&!l.id){n.Append.apply(n,l.data);o.data.splice(p+1,1);k--}else{n.rspace=l.lspace="0pt";p++}}}if(!o.data[p].isToken){this.combineRelations(o.data[p])}}}}});d.prefilterHooks.Add(function(k){k.math=d.prefilterMath(k.math,k.display,k.script)});d.postfilterHooks.Add(function(k){k.math=d.postfilterMath(k.math,k.display,k.script)});d.loadComplete("jax.js")})(MathJax.InputJax.TeX,MathJax.Hub,MathJax.Ajax);

