""" la bibliothèque webbrowser doit être préalablement importée en saisissant la commande 'pip install webbrowser' dans la fenêtre shells (fenêtre de commande)""" 
import webbrowser       # importation de la bibliothèque permettant d'afficher une page web dans un navigateur

#---------------- définition de la fonction de conversion des angles de positionnement GPS ------------------
def conversion(angle,direction):
    """conversion d'une d'un angle du format texte (ddmm.mmmm, N ou S) au format numérique dd.dddd
    exemple : '3807.423,N'est converit en : 38.12371666666667 ° """
    resultat=float(angle) # conversion de l'angle en un nombre reel
    resultat=resultat/100
    resultat=int(resultat)+(resultat-int(resultat))*100/60 # conversion des degrés minutes en degrés
    if direction=='W' or direction=='S':    # si la lattitude est sud (S) ou la longitude est ouest (W) l'angle est négatif
        resultat=-resultat
    return resultat

#-------------------- trame NMEA -------------------------------------------------
reception='$GPGGA,153026.590,4851.475,N,00217.699,E,1,12,1.0,0.0,M,0.0,M,,*6D'

#-------------------- traitement de la trame-------------------------------------
trame=reception.split(',') #découpage de la trame en morceaux, par exemple trame[1] contient l'heure de réception heures-minutes-secondes

#--------------------- exploitation d'une partie des informations contenues dans la trame -------------------------
print('heure de réception : ',trame[1][0:2],'h ',trame[1][2:4],'min ',trame[1][4:10],'s UTC')# les deux premiers caractères (de 0 à 2) du premier élément de la trame sont les heures
print('latitude : ',trame[2][0:2],'° ',trame[2][2:8],"'",trame[3])


print('---------------------------------------------------------------')

#---------------------- positionnement sur une carte du point localisé par la trame ---------------------------
reponse=input('Voulez vous afficher la carte o/n ? :')
if reponse=='o' or reponse=='O':
    webbrowser.open('https://www.google.com/maps/search/?api=1&query='+str(conversion(trame[2],trame[3]))+','+str(conversion(trame[4],trame[5]))) 


 

        