# -*- coding: utf-8 -*-

#####################
#		    #
#     Seuil N&B     #
#		    #
#####################

# Importation de la librairie PIL
from PIL import Image, ImageOps

# Ouverture du fichier image
fichierImage = 'photo.jpg'
imageSource = Image.open(fichierImage)

# Affichage de l'image pour comparaison
imageSource.show()

# Récupération de la largeur et hauteur de l'image
largeur,hauteur = imageSource.size

# Création d'une image temporaire et finale de même type
imageTempGrise = Image.new(imageSource.mode,imageSource.size)
imageFinale = Image.new(imageSource.mode,(largeur,hauteur))

# Transformation de l'image en niveau de gris - Utilisation de la méthode de PIL pour optimiser la vitesse de transformation couleur -> niveau de gris
imageTempGrise = ImageOps.grayscale(imageSource)
imageTempGrise.show()

for x in range(largeur):
	for y in range(hauteur):
		pixel = imageTempGrise.getpixel((x,y))
		if pixel>128 :
			p=(255,255,255)
		else:
			p=(0,0,0)
		imageFinale.putpixel((x,y), p)

# Affichage de l'image finale et enregistrement
imageFinale.show()
imageFinale.save("Image finale - Seuil N&B.jpg")

# Fermeture du fichier image
imageSource.close()
