# -*- coding: utf-8 -*-

##############################
#			     #
#     Symétrie verticale     #
#			     #
##############################

# Importation de la librairie PIL
from PIL import Image

# Ouverture du fichier image
fichierImage = 'photo.jpg'
imageSource = Image.open(fichierImage)
imageSource.show()

# Récupération de la largeur et hauteur de l'image
largeur,hauteur = imageSource.size

# Création d'une image de même type
imageFinale = Image.new(imageSource.mode,imageSource.size)

# Symétrie verticale
for x in range(largeur):
	for y in range(hauteur):
		pixel = imageSource.getpixel((x,y))
		imageFinale.putpixel((x,hauteur-y-1), pixel)

# Affichage de l'image finale et enregistrement
imageFinale.show()
imageFinale.save("Image finale - symetrie verticale.jpg")

# Fermeture du fichier image
imageSource.close()
