# -*- coding: utf-8 -*-

#########################################
#					#
#	Récupération des données GPS	#
#					#
#########################################


# Importation des librairies
from PIL import Image
from PIL.ExifTags import TAGS, GPSTAGS


#####################
#     Fonctions     #
#####################

# Retourne un dictionnaire des données EXIF de l'image et converti les "tags" GPS
def get_exif_data(image):
    exif_data = {}
    info = image._getexif()
    if info:
        for tag, value in info.items():
            decoded = TAGS.get(tag, tag)
            if decoded == "GPSInfo":
                gps_data = {}
                for gps_tag in value:
                    sub_decoded = GPSTAGS.get(gps_tag, gps_tag)
                    gps_data[sub_decoded] = value[gps_tag]

                exif_data[decoded] = gps_data
            else:
                exif_data[decoded] = value

    return exif_data

# Conversion des coordonnées GPS stockées dans les EXIFS en degrés
def _convert_to_degress(value):
    deg_num, deg_denom = value[0]
    d = float(deg_num) / float(deg_denom)

    min_num, min_denom = value[1]
    m = float(min_num) / float(min_denom)

    sec_num, sec_denom = value[2]
    s = float(sec_num) / float(sec_denom)

    return d + (m / 60.0) + (s / 3600.0)

# Renvoi des valeurs de latitude et longitude
def get_lat_lon(exif_data):
    latitude = None
    longitude = None

    if "GPSInfo" in exif_data:
        gps_info = exif_data["GPSInfo"]

        gps_latitude = gps_info.get("GPSLatitude")
        gps_latitude_ref = gps_info.get('GPSLatitudeRef')
        gps_longitude = gps_info.get('GPSLongitude')
        gps_longitude_ref = gps_info.get('GPSLongitudeRef')

        if gps_latitude and gps_latitude_ref and gps_longitude and gps_longitude_ref:
            latitude = _convert_to_degress(gps_latitude)
            if gps_latitude_ref != "N":
                latitude *= -1

            longitude = _convert_to_degress(gps_longitude)
            if gps_longitude_ref != "E":
                longitude *= -1

    return latitude, longitude


###############################################################
#     Chargement de l'image et affichage des informations     #
###############################################################

# Ligne à complèter pour charger l'image
exif_data = get_exif_data(image)
print ("Latitude et longitude de l'image en degrés:", get_lat_lon(exif_data))
