""" l'importation préalable de la bibliothèque networkx s'obtient en exécutant la commande conda install networksx dans la fenêtre shells"""

import networkx as nx                              # importation de la bibliothèque permettant la création de graphes
import matplotlib.pyplot as plt                    # importation de la bibliothèque permettant les tracés


adj = [[0, 1, 1, 0, 0, 0, 0],                      # matrice d'adjacence
    [1, 0, 0, 1, 0, 0, 0],
    [1, 0, 0, 0, 1, 0, 0],
    [0, 1, 1, 0, 1, 0, 0],
    [0, 0, 1, 1, 1, 1, 0],
    [0, 0, 0, 0, 1, 0, 0],
    [1, 0, 1, 0, 0, 0, 0]]

arcs=[]                                            # création de la liste contenant les arcs
for l in range(len(adj[0])):                       # construction de la liste des arcs à partir de la matrice d'adjacence
    for c in range(len(adj[0])):
        if adj[l][c]==1:
            arcs.append([l,c])

noms={0:'Claudia',1:'Johana',2:'Youma',3:'John',4:'Valentin',5:'Nabil',6:'Julie'}     # noms apparaisant dans les noeuds
G=nx.Graph()                                       # création d'un graphe vide nommé G
G.add_nodes_from([0,1,2,3,4])                      # création des noeuds du graphe G
G.add_edges_from (arcs)                            # création des arc du graphe G
nx.draw_networkx(G,labels=noms, node_size=3000)    # fabrication du graphe G avec noms et taille des noeuds

plt.show()                                         # tracé du graphe G

