// Barrière automatique simple  

#include <Servo.h>    //Inclut les fonctions permettant de piloter le servomoteur

Servo barriere;       //On affecte le nom "barriere" au servomoteur
const int CapteurLumiere = A0;  // Le capteur de luminosité est branché sur l'entrée A0
int seuil=400;            //C'est le seuil de luminosité en dessous duquel la barrière s'ouvre
int Luminosite;           //Luminosite est un nombre entier

void setup()    //Initialisation des paramètres
{
    barriere.attach(3);       //Indique que le servomoteur est branché sur la prise D3
}

void loop()     //Boucle principale
{
    Luminosite = analogRead(CapteurLumiere);  // Met dans la variable Luminosite la valeur issue du capteur de lumière
    if(Luminosite<seuil)                      // si la luminosité issue du capteur est en-dessous de la valeur seuil, ALORS
    {
       barriere.write(90);                    //met le servomoteur sur la position 90° : la barrière est levée
       delay(10000);                          //Attend 10 s
    }
    else                                      //SINON
    {
     barriere.write(0);                       //met le servomoteur sur la position 0° : la barrière est fermée
     delay(100);                              //Attend 100 ms
    }
}
