# -*- coding: utf-8 -*-

####################################
#				   #
#     Niveau de gris - Moyenne     #
#				   #
####################################

# Importation des librairies
from PIL import Image

# Ouverture du fichier image
fichierImage = 'photo.jpg'
imageSource = Image.open(fichierImage)

# Affichage de l'image pour comparaison
imageSource.show()

# Récupération de la largeur et hauteur de l'image
largeur, hauteur = imageSource.size

# Création d'une image de même type
imageFinale = Image.new(imageSource.mode,imageSource.size)

# Boucle de traitement des pixels par moyenne
for x in range(largeur):
	for y in range(hauteur):
		pixel = imageSource.getpixel((x,y)) # Sélection du pixel et récupération de ses valeurs
		gris = int((1/3) * pixel[0] + (1/3) * pixel[1] +  (1/3) * pixel[2]) # Calcul de la valeur de gris par moyenne des 3 canaux RVB
		p = (gris,gris,gris) #  On enregistre la valeur de gris dans un pixel temporaire sur les 3 canaux RVB
		imageFinale.putpixel((x,y), p) # Composition de la nouvelle image        

# Affichage de l'image finale et enregistrement
imageFinale.show()
imageFinale.save("Image finale - niveau de gris moyenne.jpg")

# Fermeture du fichier image
imageSource.close()
