/*Code Arduino 'code2_FT8_arduino.ino' version du 17/08/19.
 * Exemple de gestion d'une entrée analogique pour numériser une tension issue d'un capteur. 
 * Connecter une photodiode en série avec une résistance de 10 kOhms entre la ligne +5V et la masse GND 
 * dans le sens non passant (polarisation inverse) et appliquer la tension aux bornes de la résistance 
 * entre l'entrée analogique A0 et la masse GND (comme sur le schéma f. de l'activité 2 du capitre 1)
 * Tester le programme en faisant varier l'éclairement sur la photodiode avec la torche d'un smartphone par exemple 
 * et en ouvrant le moniteur série pour en comprendre le fonctionnement.  
 * Modifier le programme pour pouvoir afficher toutes les deux secondes, dans le moniteur série, une valeur de la variable correspondant 
 * à la tension numérisée sur l'entrée A0. 
 */

// Définition des variables :
double temps = 0;     // définition de la variable temps en double précision (8 octets = 64 bits en mémoire) pour éviter le dépassement de capacité
bool k = true;        // variable de type booléenne pour économie de la mémoire (1 octet)
                      
void setup() {        // la fonction setup() ne s'exécute qu'une fois et définit un certain nombre de paramètres pour le programme et la carte Arduino
  Serial.begin(9600); // définition de la vitesse de transmission des données dans le port série en bits/s   
  temps = millis();   // la fonction millis() permet de mesurer le temps à la milliseconde près 
}

void loop() {         // la fonction loop() est une boucle infini qui s'exécute en permanence     
  if(k == true || (millis()-temps)/10000 >= 1) {    
    Serial.println();
    Serial.print(millis()/1000);
    Serial.print(",");
    Serial.println(analogRead(A0));
    temps = millis();
    k = false;   
  }
  delay(1000);
  Serial.print(".");
}
