/*Code Arduino 'temperature_eclairement_FT9_arduino.ino' version du 17/08/19.
 * Exemple de programme permettant de mesurer une température theta à l'aide d'une thermistance 10k 
 * et un éclairement E à l'aide d'une photodiode BPW34. 
 * Connecter la photodiode en série avec une résistance de 10 kOhms entre la ligne +5V et la masse GND 
 * dans le sens non passant (polarisation inverse) et appliquer la tension aux bornes de la résistance 
 * entre l'entrée analogique A0 et la masse GND (comme sur le schéma f. de l'activité 2 du capitre 1).
 * Connecter la thermistance en série avec une résistance de 10 kOhms entre la ligne +5V et la masse GND et appliquer la tension 
 * aux bornes de la résistance entre l'entrée analogique A1 et la masse GND (comme sur le schéma c. de l'activité 2 du capitre 1). 
 * Ouvrir le moniteur série et tester le programme en faisant varier l'éclairement sur la photodiode (avec la torche d'un smartphone par exemple)
 * et en touchant la thermistance avec les doigts pour faire varier sa température. 
 * Compléter le programme pour pouvoir afficher toutes les mesures avec une seule chaine de caractère 
 * Modifier le programme pour avoir la meilleure cohérence possible avec des mesures de références.  
 */

// Définition des variables :
double temps = 0;     // définition de la variable temps en double précision (8 octets = 64 bits en mémoire) pour éviter le dépassement de capacité
bool k = true;        // variable de type booléenne pour économie de la mémoire (1 octet)
String chaineDonnees; // chaine de caractères pour enregistrer les données dans le fichier texte
float Ur = 0;         // variable de type réelle pour calculer la tension numérisée sur l'entrée A0  
float theta = 0;      // variable de type réelle pour calculer la température à partir de la tension numérisée Ur
float E = 0;          // variable de type réelle pour calculer la valeur de l'éclairement à partir de la tension sur l'entrée A1

void setup() {        // la fonction setup() ne s'exécute qu'une fois et définit un certain nombre de paramètres pour le programme et la carte Arduino
  Serial.begin(9600); // définition de la vitesse de transmission des données dans le port série en bits/s    
  temps = millis();   // la fonction millis() permet de mesurer le temps à la milliseconde près 
}

void loop() {         // la fonction loop() est une boucle infini qui s'exécute en permanence   
  if(k == true || (millis()-temps)/5000 >= 1) {    
    Ur = 5*float(analogRead(A0))/1023; // calcul de la valeur de la tension numérisée Ur à partir de la variable numérique associée à l'entrée A0 (convertie en réel)    
    theta = -20+14.1*Ur+1.54*Ur*Ur;    // calcul de la température avec la fonction température theta = f(Ur) déterminée par étalonnage de la thermistance 
    E = 0.207*float(analogRead(A1));   // calcul de la valeur de l'éclairement à partir de la variable numérique associée à l'entrée A1 (convertie en valeur réelle)
    chaineDonnees += String(theta);    // ajoute la valeur de la température theta (convertie en chaine caractères) à la chaine de caractères "chaineDonnees" 
    chaineDonnees += ",";              // ajoute une virgule à droite de la chaine de caractères "chaineDonnees"
    chaineDonnees += String(E);        // ajoute la valeur de l'éclairement E (convertie en chaine caractères) à la chaine de caractères "chaineDonnees"
    Serial.println();
    Serial.print(millis()/1000);
    Serial.print(",");
    Serial.println(chaineDonnees);
    chaineDonnees = ""; 
    temps = millis();
    k = false;   
  }
  delay(1000);
  Serial.print(".");
}
