#include "pitches.h"

// notes à jouer sur la game pentatonique en Do:
int notes[] = {NOTE_C2, NOTE_DS2, NOTE_F2, NOTE_FS2, NOTE_G2, NOTE_AS2, NOTE_C3, NOTE_DS3, NOTE_F3, NOTE_FS3, NOTE_G3, NOTE_AS3, NOTE_C4, NOTE_DS4, NOTE_F4, NOTE_FS4, NOTE_G4, NOTE_AS4,NOTE_C5};
String NOTES[] = {"Do2", "Re#2", "Fa2", "Fa#2", "Sol2", "La#2",   "Do3", "Re#3", "Fa3", "Fa#3", "Sol3", "La#3",   "Do4", "Re#4", "Fa4", "Fa#4", "Sol4", "La#4",   "Do5"};  

int seuil=84;// variable pour la production d'une note, à ajuster.
int i=1;     // variable pour la durée de la charge en us (10-6 s). 
 
void setup() {
  pinMode(6,OUTPUT); // broche 6 pour l'allumage de la DEL. 
  pinMode(11,OUTPUT);// broche 11 pour la charge et la décharge. 
  pinMode(4,OUTPUT); // broche 4 pour le signal audio. 
  Serial.begin(9600);// vitesse des données dans le port série.  
}

void loop() {
  digitalWrite(11,LOW);   // décharge du capteur capacitif.
  while(analogRead(A0)>20){ /*le capteur se décharge...*/ }   
  digitalWrite(11,HIGH);  // charge du capteur capacitif E=5,00V.
  delayMicroseconds(i);   // durée de la charge du capteur.   
  if((float(analogRead(A0))*5/1023)<4.15){ // test uc<4,15 V ? 
    i=i+1; // si oui alors on augmente la durée de charge de 1 us.
    }
  else {
    if (i>seuil){         // si i>seuil alors la note est jouée. 
      if(i>seuil+57) i=seuil+54; // seuil+51>i>seuil.   
      digitalWrite(6,HIGH);// allumage de la DEL = production note. 
      Serial.print(i);     // affichage valeur de i 
      Serial.print("  note ");        // affichage d'un message 
      Serial.print((i-seuil-1)/3);    // précisant le n° de la note 
      Serial.print("  =  ");          // ainsi que la hauteur 
      Serial.println(NOTES[(i-seuil-1)/3]);// de la note jouée.   
      tone(4, notes[(i-seuil-1)/3], 500);  // production de la note !
      //delay(1000/(i-seuil+15));        // à tester...   
      //noTone(4);                       // à tester...        
      i=1;                 // réinitialisation de i.         
    } else {                     
      digitalWrite(6,LOW); // extinction de la DEL = fin de la note.
    }
  }
}  
