#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#=====================================================================
# Chapitre 02 Exercice 29                                     STANDARD
#=====================================================================
"""
Réaction support de titrage A + B -> C + D
A : réactif titré cA (ordre de grandeur connu), vA (variable) 
B : réactif titrant cB (connue), vEqv entre vEqv_min et vEqv_max
Les ions spectateurs ne sont pas étudiés.
"""
from matplotlib import pyplot as plt

plt.figure(figsize=(10,8))

cA=float(input('Concentration du réactif titré en mol/L : cA = '))
cB=float(input('Concentration du réactif titrant en mol/L : cB = '))

for vA in range(5,101,5):            # vA en mL   
    vEqv=...A Compléter...           # Calcul de vEqv (en mL)
    v=[i*vEqv/10 for i in range(11)] # Domaine des abscisses (en mL)
    nA=[cA*vA - cB*x for x in v]     # Domaine des ordonnées (en mmol)        
    plt.plot(v,nA,label='$v_{A}$ ='+str(vA)+' mL')

plt.xlabel('Volume $v$ de solution titrante versé (en mL)')
plt.ylabel('Quantité de matière de l\'espèce titrée (en mmol)')
plt.grid(ls='--')
plt.legend()

x_min,x_max,y_min,y_max=plt.axis()
plt.xlim(0,x_max)
plt.ylim(0,y_max)
plt.suptitle('Optimisation d\'un titrage')

# Titre affichant la réaction support de titrage
reactifs = ' A$_{titré}$ +  B$_{titrant}$'
produits = ' C + D'
equation = reactifs+'$ \longrightarrow $ '+produits
plt.title('Réaction support de titrage : '+equation)

# Affichage des données du titrage
data1 ='$c_{A}$ = '+'%.2f'%cA+' mol$\cdot$L$^{-1}$,  '
data2 ='$c_{B}$ = '+'%.2f'%cB+' mol$\cdot$L$^{-1}$ '
plt.text(x_max/2,y_max*0.95,data1+data2,ha='center',fontsize=12)

plt.show()     
         

