#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#=====================================================================
# Chapitre 02 Exercice 29                                     CONFIRME
#=====================================================================
"""
Réaction support de titrage A + B -> C + D
A : réactif titré cA (ordre de grandeur connu), vA (variable) 
B : réactif titrant cB (connue), vEqv entre vEqv_min et vEqv_max
Les ions spectateurs ne sont pas étudiés.
"""
from matplotlib import pyplot as plt

plt.figure(figsize=(10,8))

cA=float(input('Concentration du réactif titré en mol/L : cA = '))
cB=float(input('Concentration du réactif titrant en mol/L : cB = '))

for vA in range(5,101,5):            # vA en mL   
    vEqv=...A Compléter...           # Calcul de vEqv (en mL)
    v=[i*vEqv/10 for i in range(11)] # Domaine des abscisses (en mL)
    nA=[cA*vA - cB*x for x in v]     # Domaine des ordonnées (en mol)        
    plt.plot(v,nA,label='$v_{A}$ ='+str(vA)+' mL')

plt.xlabel('Volume $v$ de solution titrante versé (en mL)')
plt.ylabel('Quantité de matière de l\'espèce titrée (en mol)')
plt.grid(ls='--')
plt.legend()

x_min,x_max,y_min,y_max=plt.axis()
plt.xlim(0,x_max)
plt.ylim(0,y_max)
plt.suptitle('Optimisation d\'un titrage')

# Titre affichant la réaction support de titrage
reactifs = ' A$_{titré}$ +  B$_{titrant}$'
produits = ' C + D'
equation = reactifs+'$ \longrightarrow $ '+produits
plt.title('Réaction support de titrage : '+equation)

# Affichage des données du titrage
data1 ='$c_{A}$ = '+'%.2f'%cA+' mol$\cdot$L$^{-1}$,  '
data2 ='$c_{B}$ = '+'%.2f'%cB+' mol$\cdot$L$^{-1}$ '
plt.text(x_max/2,y_max*0.95,data1+data2,ha='center',fontsize=12)

plt.show()     

 
#=====================================================================
# Niveau CONFIRME : Question complémentaire
# Avant de répondre à cette question, placer une série de 3 guillemets
# aux lignes 13 et 47 et retirer ceux des lignes 70 et 108.
#=====================================================================

"""
Le volume vA est désormais fixé à vA = 40.0 mL.
La solution de réactif titrant peut être préparée à des concentrations
comprises entre cB = 0.040 mol/L et cB = 0.200 mol/L.

Réaction support de titrage A + B -> C + D
A : réactif titré cA (ordre de grandeur connu), vA (connu)
B : réactif titrant cB (variable), vEqv entre vEqv_min et vEqv_max
Les ions spectateurs ne sont pas étudiés.

Compléter le code ci-dessous afin de permettre la détermination,
par lecture graphique, d'un encadrement de valeurs de cB permettant
d'optimiser l'incertitude sur le titrage.
"""

"""
import numpy as np

plt.figure(figsize=(10,8))

# Entrées :
vA=...A Compléter...    # Volume vA en mL
cA=...A Compléter...    # Concentration cA en mol/L 

for cB in np.arange(...A compléter...): # Valeurs de cB (en mol/L)
                                        # tous les 0.01 mol/L
    vEqv=...A Compléter...    # Calcul de vEqv (en mL)
    v=...A Compléter...       # Domaine des abscisses (en mL)
    nA=...A Compléter...      # Domaine des ordonnées (en mmol)        
    ...A Compléter...         # Tracé de nA = f(v), légendé selon cB

plt.xlabel('Volume $v$ de solution titrante versé (en mL)')
plt.ylabel('Quantité de matière de l\'espèce titrée (en mmol)')
plt.grid(ls='--')
plt.legend()

x_min,x_max,y_min,y_max=plt.axis()
plt.xlim(0,x_max)
plt.ylim(0,y_max)
plt.suptitle('Optimisation d\'un titrage pour $c_B$ variable')

# Titre affichant la réaction support de titrage
reactifs = ' A$_{titré}$ +  B$_{titrant}$'
produits = ' C + D'
equation = reactifs+'$ \longrightarrow $ '+produits
plt.title('Réaction support de titrage : '+equation)

# Affichage des données du titrage
data1 ='$c_{A}$ = ...A Compléter...  '
data2 ='$v_{A}$ = ...A Compléter... '
plt.text(x_max/2,y_max*0.95,data1+data2,ha='center',fontsize=12)

plt.show()              
"""
