#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# ====================================================================
# Chapitre 13 - Exercice 42 - CONFIRME                           ELEVE
# ====================================================================
"""
La partie 1 de ce programme permet de tester la deuxième loi de Kepler
à partir de l'éphéméride de Venus du fichier Kepler2_Venus.txt.
La partie 2 permet d'en déduire la masse du Soleil.
"""
# ====================================================================
# Partie 1 : Tester la deuxième loi de Kepler
# ====================================================================

# ============ Extraction des données : NE PAS MODIFIER ==============

#Fonction permettant de convertir la longitude sous forme décimale
def decimale_long(d):
    deg=int(d[1:4])
    minute=int(d[5:7])/60
    seconde=(int(d[8:10])+int(d[11:15])/10000)/3600
    return float(deg+minute+seconde)

ua=1.495978707e11  # unité astronomique (en mètre)

# Instructions permettant l'extraction des données
date,longitude,distance=[],[],[]
with open('Kepler2_Venus.txt') as fichier:
    line = fichier.readline()
    while line:
        data0,data1,data2,data3,data4,data5=line.split(',')
        date.append(data1)     # date (en année,mois,jour,heure,min,s)
        longitude.append(decimale_long(data2))  # longitude (en degré)
        distance.append(float(data4)*ua)    # Rayon de l'orbite (en m)
        line = fichier.readline()
# ====================================================================
from math import pi
from matplotlib import pyplot as plt
import numpy as np

# Fonction permettant de calculer l'aire d'un secteur
def aire(angle,r):
    """ Calcul de l'aire en m^2 d'un secteur d'angle au sommet
    'angle' (en degré)  et de rayon 'r' (en m) """
    aire=(pi*angle*r**2)/360
    return aire

N = len(longitude)
t = range(N)

Aire=[0]
aire_balayee=0
for i in range(N-1):
    angle=longitude[i+1]-longitude[i]
    r=distance[i]
    a=aire(angle,r)
    aire_balayee = aire_balayee + a
    Aire.append(aire_balayee)

plt.plot(t,Aire)

plt.xlim(min(t),max(t))
plt.ylim(min(Aire),max(Aire))
plt.title('Test de la loi des aires sur Venus')
plt.xlabel('Nombre de jours depuis la date t$_{0}$ ='+str(date[0]))
plt.ylabel('Aire balayée depuis la date t$_{0}$ (en $\mathrm{m}^{2}$)')
plt.grid()
plt.show()
    
# ====================================================================
# Partie 2 : Estimer la masse M_S du Soleil (question e)
# ====================================================================
# Entrées

R=...A compléter...    # Valeur de R (en SI)
u_R=...A compléter...  # Incertitude-type associée (en SI)

from scipy.stats import linregress
reg=...A compléter...  # Regression linéaire de (t,Aire)
k=...A compléter...    # Valeur de k (en SI)
u_k=...A compléter...  # Incertitude-type associée (en SI)

G=...A compléter...    # Constante de gravitation (en SI)
u_G=...A compléter...  # Incertitude-type associée (en SI)

# ====================================================================
# Méthode analytique pour le calcul de M_S et u(M_S) (en SI)

M_S=...A compléter...  # Calcul de la masse du Soleil (en SI)
u_M_S=...A compléter...# Incertitude-type associée (en SI)

print('\nMéthode analytique :')
print('Masse du Soleil M_Soleil =',...A compléter...) 
print('Incertitude type u(M_Soleil) =', ...A compléter...)

# ====================================================================
# Méthode de Monte-Carlo pour le calcul de M_S et u(M_S) (en SI)

# Création des listes L=[Valeur,Incertitude-type] pour R, k et G
L_R=...A compléter...  # Liste R (en SI)
L_k=...A compléter...  # Liste k (en SI)
L_G=...A compléter...  # Constante de gravitation (en SI)

# Simulation d'une distribution d pour la masse du Soleil (en SI)
def Alea(L): # Tirage aléatoire selon la loi normale
    return np.random.normal(L[0],L[1])
d=[]
Iteration=100000
for i in range(Iteration):
    Alea_M_S=...A compléter... # Valeur aléatoire de la masse du Soleil (en SI)
    d.append(Alea_M_S)

# Calcul de M_S et u(M_S) (en SI)
M_S=...A compléter...   # M_S <- Valeur moyenne de la distribution d
u_M_S=...A compléter... # u(M_S) <- Ecart-type de la distribution d

print('\nMéthode de Monte-Carlo :')
print('\nMasse du Soleil M_Soleil =',...A compléter...) 
print('Incertitude type u(M_Soleil) =',...A compléter...)









