#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# ==============================================================================
# EXERCICE 44 p183                                                    CORRECTION
# Programme permettant de déterminer le pH (à 0,05 près) d'une solution obtenue  
# par dissolution d'un acide dans l'eau, suivant la nature de l'acide (fort ou 
# faible), à partir de la donnée de la concentration en acide apporté c, 
# et du pKa du couple acide-base si l'acide est faible.
# ==============================================================================

# Import de la fonction logarithme décimal depuis la bibliothèque "math"
from math import log10

# Fonction calculant le quotient de réaction à partir de la valeur du pH et de 
# la concentration en quantité d'acide faible introduit c
def Qr(c,pH):
    h=10**(-pH)
    return h**2/(c-h)

# Fonction permettant d'arrondir une valeur de pH à 0.05 untié près
def arrondi(pH):
    return 0.05*round(20*pH)

# Demande à l'utilisateur la concentration en quantité d'acide introduit
c=float(input("Concentration en quantité d'acide apporté (en mol/L) : "))

# Demande à l'utilisateur la nature de l'acide : fort (F) ou faible (f)
reponse=input("Quelle est la nature de l'acide ? Réponse = F si acide fort, \
ou f si acide faible : ")

# Calcul du pH en fonction de la nature de l'acide
if reponse=="F":
    pH=-log10(c)
    print("Le pH de la solution vaut :",'{:.2f}'.format(arrondi(pH)))
else:
    # Demande du pKa du couple acide-base à l'utilisateur :
    pKa=float(input("Valeur du pKa de l'acide faible introduit : "))
    Ka=10**(-pKa)    # Calcul de la constante d'acidité
    pH=7.0           # Initialisation du pH
    # Boucle simulant l'abaissement progressif du pH de la solution,
    # jusu'à ce que la loi de l'équilibre soit vérifiée :
    while Qr(c,pH)<Ka:
        pH=pH-0.05               # Abaissement du pH

    # Affichage du pH à l'équilibre :
    print("Le pH de la solution vaut :",'{:.2f}'.format(pH))
    