#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# ====================================================================
# Chapitre 13 - Exercice 42 - STANDARD                           ELEVE
# ====================================================================
"""
La partie 1 de ce programme permet de tester la deuxième loi de Kepler
à partir de l'éphéméride de Venus du fichier Kepler2_Venus.txt.
La partie 2 permet d'en déduire la masse du Soleil.
"""
# ====================================================================
# Partie 1 : Tester la deuxième loi de Kepler
# ====================================================================

# ============ Extraction des données : NE PAS MODIFIER ==============

#Fonction permettant de convertir la longitude sous forme décimale
def decimale_long(d):
    deg=int(d[1:4])
    minute=int(d[5:7])/60
    seconde=(int(d[8:10])+int(d[11:15])/10000)/3600
    return float(deg+minute+seconde)

ua=1.495978707e11  # unité astronomique (en mètre)

# Instructions permettant l'extraction des données
date,longitude,distance=[],[],[]
with open('Kepler2_Venus.txt') as fichier:
    line = fichier.readline()
    while line:
        data0,data1,data2,data3,data4,data5=line.split(',')
        date.append(data1)
        longitude.append(decimale_long(data2))
        distance.append(float(data4)*ua)
        line = fichier.readline()
# ====================================================================
from math import pi
from matplotlib import pyplot as plt
import numpy as np

# Fonction permettant de calculer l'aire d'un secteur
def aire(angle,r):
    """ Calcul de l'aire en m^2 d'un secteur d'angle au sommet
    'angle' (en degré)  et de rayon 'r' (en m) """
    aire=(pi*angle*r**2)/360
    return aire

N = len(longitude)
t = range(N)

Aire=[0]
aire_balayee=0
for i in range(N-1):
    angle=longitude[i+1]-longitude[i]
    r=distance[i]
    a=aire(angle,r)
    aire_balayee = aire_balayee + a
    Aire.append(aire_balayee)
    
plt.plot(t,Aire)

plt.xlim(min(t),max(t))
plt.ylim(min(Aire),max(Aire))
plt.title('Test de la loi des aires sur Venus')
plt.xlabel('Nombre de jours depuis la date t$_{0}$ ='+str(date[0]))
plt.ylabel('Aire balayée depuis la date t$_{0}$ (en $\mathrm{m}^{2}$)')
plt.grid()
plt.show()

# ====================================================================
# Partie 2 : Estimer la masse M_S du Soleil (question e)
# ====================================================================

G=...A compléter...   # Constante de gravitation (en SI)

k=...A compléter...   # Valeur de k (en SI)

R=...A compléter...   # Valeur de R (en SI)

M_S=...A compléter... # Calcul de la masse du Soleil (en SI)

print(...A compléter...) 

