#include "Statistic.h" // importe la bibliothèque Statistic.
Statistic stat;        // créer un objet stat pour faire des statistiques.

long i=0;   // variable pour la durée de la charge en us (10-6 s).  
int k=100;  // variable pour la durée de charge.  
int n=0;    // nombre de mesures par tau moyen.

void setup() {
  pinMode(11,OUTPUT); // broche 11 pour la charge et la décharge. 
  Serial.begin(9600); // vitesse des données dans le port série.
  stat.clear();       // réinitialise  les données statistiques
}

void loop() {
  digitalWrite(11,LOW);   // décharge du capteur capacitif. 
  while(analogRead(A0)>1){ /*le capteur se décharge...*/ }   
  digitalWrite(11,HIGH);  // charge du capteur capacitif.  
  delayMicroseconds(i);   // durée de la charge du capteur. 
  if(analogRead(A0)<647){ // test uc<0,632*E ? 
    i=i+k;         // si oui alors on augmente la durée de charge de k us.
    }          
  else if(k==100){ // si non alors on diminue la durée de charge de      
    i=i-k;         // k=100 us pour approcher la durée de charge                    
    k=10;          // à k=10 us près.
  }
  else if(k==10){  // si uc>=0,632*E et si k=10 us alors on on diminue la      
    i=i-10;        // durée de charge de k=10 us pour approcher la durée          
    k=1;           // de charge à la microseconde près.
    if(i<0)i=0;    // tau ne peut pas être négatif, au minimum nul.
  }
  else{                 // la mesure de tau de n°n est stockée. 
    n++;                // on passe à la mesure suivante n°n+1.    
    stat.add(i);        // ajoute la valeur dans les données statistiques.                     
    Serial.print(i); Serial.print("/"); // affiche les valeurs mesurées.     
    i=0; k=100;  
    if(n==20){// affichage de la moyenne des temps caractéristiques. 
      Serial.println();
      Serial.println("Toutes les mesures sont exprimées en us");
      Serial.println("tmin\t|    tmax\t|    tmoyen\t|    u(tmoyen)");      
      Serial.print(stat.minimum()); Serial.print("\t|    "); // minimum. 
      Serial.print(stat.maximum()); Serial.print("\t|    "); // maximum.
      Serial.print(stat.average()); Serial.print("\t|    "); // moyenne.                   
      Serial.println(stat.pop_stdev()/sqrt(20));    // incertitude-type.       
      stat.clear();            // réinitialise les données statistiques.          
      n=0;                     // réinitialisation des variables. 
      delay(2000);             // pause de 2s pour la lecture.                
    }
  } 
}
