/*Code Arduino 'code1_FT8_arduino.ino' version du 17/08/19.
 * Exemple de gestion d'une sortie sur une broche numérique pour commander une DEL. 
 * Connecter une DEL en série avec une résistance de 330 Ohms entre la broche numérique DIGITAL 2 
 * et la masse GND dans le sens passant et tester le programme pour en comprendre le fonctionnement. 
 * Modifier le programme pour qu'il affiche un seul bref éclair lumineux d'une durée de 5 millisecondes 
 * toutes les 2 secondes et un allumage long de 2 secondes toutes les minutes.
 */

// Définition des variables :
double temps = 0;    // définition de la variable temps en double précision (8 octets = 64 bits en mémoire) pour éviter le dépassement de capacité
   
void setup() {       // la fonction setup() ne s'exécute qu'une fois et définit un certain nombre de paramètres pour le programme et la carte Arduino
  pinMode(2,OUTPUT); // définition de la broche numérique DIGITAL 2 comme une sortie    
  temps = millis();  // la fonction millis() permet de mesurer le temps à la milliseconde près 
}

void loop() {        // la fonction loop() est une boucle infini qui s'exécute en permanence
  delay(880);
  digitalWrite(2, HIGH);      
  delay(10);                
  digitalWrite(2, LOW);       
  delay(100);               
  digitalWrite(2, HIGH);    
  delay(10);                
  digitalWrite(2, LOW);  
  if((millis()-temps)/9000 == 1) {    
    digitalWrite(2, HIGH);  
    delay(1000);              
    digitalWrite(2, LOW);
    temps = millis();   
  } 
}
