var dom = {};
var data = [
  { txt: "", example: "" },
  { txt: "", example: "" },
  { txt: "", example: "" },
  { txt: "", example: "" },
];
var answers = [
  {
    txt: "produit",
    example: "",
  },
  {
    txt: "demande",
    example: ")",
  },
  {
    txt: "offre",
    example: "",
  },
  {
    txt: "prix",
    example: "",
  },
];

var _line1 = null;
var _line2 = null;
var _line3 = null;
var _line4 = null;
var _try = 0;
var goodAnswer =0

/** MINDMAP LINE */
var optionLine = { path: "straight", startPlug: "behind", endPlug: "arrow2" };
function initDom() {
  dom.appContent = document.getElementById("app-content_content");
  dom.appHeader = document.getElementById("app-content_header");
  dom.col_1_bloc_1 = document.getElementById("col-1-bloc-1");
  dom.col_2_bloc_1 = document.getElementById("col-2-bloc-1");
  dom.col_2_bloc_2 = document.getElementById("col-2-bloc-2");
  dom.col_3_bloc_1 = document.getElementById("col-3-bloc-1");
  dom.col_4 = document.getElementById("col-4");

  dom.col_2_bloc_gosth = document.getElementById("col-2-bloc-gost");
  dom.contenteditable_1 = document.getElementById("contenteditable-1");
  dom.contenteditable_2 = document.getElementById("contenteditable-2");
  dom.contenteditable_3 = document.getElementById("contenteditable-3");
  dom.contenteditable_4 = document.getElementById("contenteditable-4");
  dom.info = document.getElementById("info");
  dom.centerBloc = document.getElementById("col-2");
  dom.valid = document.getElementById("valid");
  dom.answer = document.getElementById("answer");
  dom.try = document.getElementById("try");
  dom.answer_student = document.getElementById("answer_student");
  dom.elts = document.querySelectorAll("div[contenteditable]");
}

function createLines() {
  _line1 = new LeaderLine(
    LeaderLine.pointAnchor(dom.col_1_bloc_1, {
      x: "50%",
      y: "50%",
    }),

    LeaderLine.pointAnchor(dom.col_2_bloc_gosth, {
      x: "50%",
      y: "0%",
    }),
    mergeObjects(optionLine, { middleLabel: "Confrontation entre" })
  );
  _line2 = new LeaderLine(
    LeaderLine.pointAnchor(dom.col_2_bloc_1, {
      x: "50%",
      y: "100%",
    }),

    LeaderLine.pointAnchor(dom.col_4, {
      x: "50%",
      y: "0%",
    }),
    optionLine
  );

  _line3 = new LeaderLine(
    LeaderLine.pointAnchor(dom.col_2_bloc_2, {
      x: "50%",
      y: "100%",
    }),

    LeaderLine.pointAnchor(dom.col_4, {
      x: "50%",
      y: "0%",
    }),
    optionLine
  );

  _line4 = new LeaderLine(
    LeaderLine.pointAnchor(dom.col_4, {
      x: "50%",
      y: "100%",
    }),

    LeaderLine.pointAnchor(dom.col_3_bloc_1, {
      x: "50%",
      y: "0%",
    }),
    optionLine
  );
}

function mergeObjects(obj1, obj2) {
  var mergedObj = {};

  for (var prop in obj1) {
    if (obj1.hasOwnProperty(prop)) {
      mergedObj[prop] = obj1[prop];
    }
  }

  for (var prop in obj2) {
    if (obj2.hasOwnProperty(prop)) {
      mergedObj[prop] = obj2[prop];
    }
  }

  return mergedObj;
}

function toggleValid(isShow) {
  if (isShow) {
    dom.valid.classList.remove("isHide");
  } else {
    dom.valid.classList.add("isHide");
  }
}

function updateData(index, value, type) {
  _line1.position();
  _line2.position();
  _line3.position();
  _line4.position();

  data[index].txt = value;

  var nb = 0;
  for (var i = 0; i < data.length; i++) {
    if (data[i].txt !== "") {
      nb += 1;
    }
  }
  if (nb === 4) {
    toggleValid(true);
  } else {
    toggleValid(false);
  }
}

function showAnswer() {
  
  setAnswers(answers);
  valid();
  dom.answer.classList.add("isHide");
  dom.answer_student.classList.remove("isHide");
}

function setAnswers(data) {
  for (var i = 0; i < dom.elts.length; i++) {
    dom.elts[i].setAttribute("contenteditable", false);
    dom.elts[i].innerHTML = data[i].txt;
  }
}

function showStudentAnswer() {
  setAnswers(data);
  valid();
  dom.answer.classList.remove("isHide");
  dom.answer_student.classList.add("isHide");
}

function tryAgain() {
  _try += 1;
  dom.try.classList.add('isHide')
  for (var i = 0; i < dom.elts.length; i++) {
    if (dom.elts[i].className.indexOf("isBad") > -1) {
      dom.elts[i].setAttribute("contenteditable", true);
      dom.elts[i].classList.remove("isBad");
      data[i].txt = "";
      dom.elts[i].innerHTML = "";
    }
  }
}

function valid() {
  for (var i = 0; i < dom.elts.length; i++) {
    dom.elts[i].classList.remove("isGood");
    dom.elts[i].classList.remove("isBad");
  }
  if (dom.contenteditable_1.innerText.toLowerCase().trim() === answers[0].txt) {
    dom.contenteditable_1.classList.add("isGood");
    goodAnswer+=1
  } else {
    dom.contenteditable_1.classList.add("isBad");
  }

  if (dom.contenteditable_2.innerText.toLowerCase().trim() === answers[1].txt || dom.contenteditable_2.innerText.toLowerCase().trim() === answers[2].txt) {
    dom.contenteditable_2.classList.add("isGood");
    goodAnswer+=1
  } else {
    dom.contenteditable_2.classList.add("isBad");
  }

  if (dom.contenteditable_3.innerText.toLowerCase().trim() === answers[2].txt || dom.contenteditable_3.innerText.toLowerCase().trim() === answers[1].txt) {
    dom.contenteditable_3.classList.add("isGood");
    goodAnswer+=1
  } else {
    dom.contenteditable_3.classList.add("isBad");
  }

  if (dom.contenteditable_4.innerText.toLowerCase().trim() === answers[3].txt) {
    dom.contenteditable_4.classList.add("isGood");
    goodAnswer+=1
  } else {
    dom.contenteditable_4.classList.add("isBad");
  }

  for (var i = 0; i < dom.elts.length; i++) {
    dom.elts[i].setAttribute("contenteditable", false);
  }
  dom.valid.classList.add('isHide')
  
  if(_try===1 && goodAnswer!==4){
    dom.answer.classList.remove('isHide')
  }
  else if(goodAnswer===4){

  } else if(_try===0 ){
    dom.try.classList.remove('isHide')
  }
}

function initEvent() {
  dom.contenteditable_1.addEventListener("input", function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });
  dom.contenteditable_2.addEventListener("input", function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });
  dom.contenteditable_3.addEventListener("input", function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });
  dom.contenteditable_4.addEventListener("input", function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });

  dom.try.addEventListener("click", function () {
    tryAgain();
  });

  dom.answer.addEventListener("click", function () {
    showAnswer();
  });
  dom.answer_student.addEventListener("click", function () {
    showStudentAnswer();
  });

  dom.valid.addEventListener("click", function () {
    valid();
  });
  dom.contenteditable_1.focus();
}

function initApp() {
  initDom();
  initEvent();
  createLines();
  dom.info.classList.remove("hide");
}

window.addEventListener("load", initApp);
