var dom = {};
var data = [{ txt: "",example:"" }, { txt: "",example:"" }, { txt: "",example:""}, { txt: "",example:"" }];
var answers = [
  {
    txt: "Médias",
    example: "Règles de sociabilité",
  },
  {
    txt: "École",
    example: "Façons de travailler (en groupe, individuellement)",
  },
  {
    txt: "Famille",
    example: "Règles de politesse",
  },
  {
    txt: "Groupe de pairs",
    example: "Goûts musicaux et culturels",
  },
];
/** MINDMAP LINE */
var optionLine = { path: "grid", startPlug: "behind", endPlug: "arrow2" };
function initDom() {
  dom.appContent = document.getElementById("app-content_content");
  dom.appHeader = document.getElementById("app-content_header");
  dom.col_1_bloc_1 = document.getElementById("col-1-bloc-1");
  dom.col_1_bloc_2 = document.getElementById("col-1-bloc-2");
  dom.col_3_bloc_1 = document.getElementById("col-3-bloc-1");
  dom.col_3_bloc_2 = document.getElementById("col-3-bloc-2");
  dom.contenteditable_1 = document.getElementById("contenteditable-1");
  dom.contenteditable_2 = document.getElementById("contenteditable-2");
  dom.contenteditable_3 = document.getElementById("contenteditable-3");
  dom.contenteditable_4 = document.getElementById("contenteditable-4");

 


  dom.info=document.getElementById('info')
  dom.contenteditable_1_example = document.getElementById(
    "contenteditable-1-example"
  );
  dom.contenteditable_2_example = document.getElementById(
    "contenteditable-2-example"
  );
  dom.contenteditable_3_example = document.getElementById(
    "contenteditable-3-example"
  );
  dom.contenteditable_4_example = document.getElementById(
    "contenteditable-4-example"
  );
  dom.centerBloc = document.getElementById("col-2");
  dom.valid = document.getElementById("valid");
  dom.answer = document.getElementById("answer");
}

function createLines() {
  new LeaderLine(
    LeaderLine.pointAnchor(dom.centerBloc, {
      x: "50%",
      y: "50%",
    }),

    LeaderLine.pointAnchor(dom.col_1_bloc_1, {
      x: "100%",
      y: "30%",
    }),
    optionLine
  );
  new LeaderLine(
    LeaderLine.pointAnchor(dom.centerBloc, {
      x: "50%",
      y: "50%",
    }),

    LeaderLine.pointAnchor(dom.col_1_bloc_2, {
      x: "100%",
      y: "70%",
    }),
    optionLine
  );

  new LeaderLine(
    LeaderLine.pointAnchor(dom.centerBloc, {
      x: "50%",
      y: "50%",
    }),

    LeaderLine.pointAnchor(dom.col_3_bloc_1, {
      x: "0%",
      y: "30%",
    }),
    optionLine
  );

  new LeaderLine(
    LeaderLine.pointAnchor(dom.centerBloc, {
      x: "50%",
      y: "50%",
    }),

    LeaderLine.pointAnchor(dom.col_3_bloc_2, {
      x: "0%",
      y: "70%",
    }),
    optionLine
  );
}

function toggleValid(isShow) {
  if (isShow) {
    dom.valid.classList.remove("hide");
  } else {
    dom.valid.classList.add("hide");
  }
}

function updateData(index, value,type) {
  if(type==="example"){
    console.log(data[index])
    data[index].example = value;
  } else {
    data[index].txt = value;
  }
  
  var nb = 0;
  for (var i = 0; i < data.length; i++) {
    if (data[i].txt !== "") {
      nb += 1;
    }
  }
  if (nb === 4) {
    toggleValid(true);
  } else {
    toggleValid(false);
  }
}


function showAnswer(){
  dom.answer.classList.add("hide");
  dom.valid.classList.remove("hide");
  dom.contenteditable_1.innerHTML = data[0].txt;
  dom.contenteditable_2.innerHTML = data[1].txt;
  dom.contenteditable_3.innerHTML = data[2].txt;
  dom.contenteditable_4.innerHTML = data[3].txt;
  dom.contenteditable_1_example.innerHTML = data[0].example;
  dom.contenteditable_2_example.innerHTML = data[1].example;
  dom.contenteditable_3_example.innerHTML = data[2].example;
  dom.contenteditable_4_example.innerHTML = data[3].example;
}

function showCorrection() {
  
  dom.answer.classList.remove("hide");
  dom.valid.classList.add("hide");
  var elts = document.querySelectorAll("div[contenteditable]");

  for (var i = 0; i < elts.length; i++) {
    elts[i].setAttribute("contenteditable", false);
    
  }
  dom.contenteditable_1.innerHTML = answers[0].txt;
  dom.contenteditable_2.innerHTML = answers[1].txt;
  dom.contenteditable_3.innerHTML = answers[2].txt;
  dom.contenteditable_4.innerHTML = answers[3].txt;
  dom.contenteditable_1_example.innerHTML = answers[0].example;
  dom.contenteditable_2_example.innerHTML = answers[1].example;
  dom.contenteditable_3_example.innerHTML = answers[2].example;
  dom.contenteditable_4_example.innerHTML = answers[3].example;
  
}

function initEvent() {
  dom.contenteditable_1.addEventListener("input", function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });
  dom.contenteditable_2.addEventListener("input", function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });
  dom.contenteditable_3.addEventListener("input", function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);
  });
  dom.contenteditable_4.addEventListener("input", function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText);

  });

  dom.contenteditable_1_example.addEventListener("input", function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText,'example');
  });
  dom.contenteditable_2_example.addEventListener("input", function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText),'example';
  });
  dom.contenteditable_3_example.addEventListener("input", function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText,'example');
  });
  dom.contenteditable_4_example.addEventListener("input", function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText,'example');

  });



 
  dom.answer.addEventListener("click", function () {
    showAnswer()
   });

  dom.valid.addEventListener("click", function () {
   showCorrection()
  });
  dom.contenteditable_1.focus()
}

function initApp() {
  initDom();
  initEvent();
  createLines();
  
  dom.info.classList.remove("hide")
 
  
}

window.addEventListener("load", initApp);
