var dom = {};
var data = [
  { txt: '', example: '' },
  { txt: '', example: '' },
  { txt: '', example: '' },
  { txt: '', example: '' },
  { txt: '', example: '' },
  { txt: '', example: '' },
  { txt: '', example: '' },
  { txt: '', example: '' },
];


var optionLine = { path: 'arc', startPlug: 'behind', endPlug: 'arrow2' };
var hasTry = 0;
var inPlaced = 0;
var examples =["salaires non perçu (cout d'opportunité), financement d'une école privée, des fournitures, d'un déménagement","moins de chômage, salaires plus élevés, opportunités de carrière","avoir la liberté de faire ses choix de vie, de s’exprimer, avoir la capacité de défendre ses droits"];

var isGood = 0;
var answers = [
  {
    txt: 'études',
    example: '',
  },
  {
    txt: 'dépenses',
    example:
      "",
  },
  {
    txt: 'avantages',
    example: '',
  },
  {
    txt: 'avantages',
    example: '',
  },
  {
    txt: 'dépenses',
    example: '',
  },
  {
    txt: 'capital humain',
    example: '',
  },
  {
    txt: 'études',
    example: '',
  },
  {
    txt: 'capabilités',
    example: '',
  },
];
var toPlaced = answers.length;
function createLines() {
  _line1 = new LeaderLine(
    LeaderLine.pointAnchor(dom.bloc_multiple_1, {
      x: '50%',
      y: '0%',
    }),

    LeaderLine.pointAnchor(dom.bloc_multiple_2, {
      x: '20%',
      y: '0%',
    }),
    optionLine
  );
  _line2 = new LeaderLine(
    LeaderLine.pointAnchor(dom.bloc_multiple_2, {
      x: '80%',
      y: '0%',
    }),

    LeaderLine.pointAnchor(dom.bloc_multiple_3, {
      x: '50%',
      y: '0%',
    }),
    optionLine
  );
  _line3 = new LeaderLine(
    LeaderLine.pointAnchor(dom.bloc_multiple_1, {
      x: '50%',
      y: '100%',
    }),

    LeaderLine.pointAnchor(dom.bloc_multiple_4, {
      x: '0%',
      y: '50%',
    }),
    {
      ...optionLine,
      path: 'straight',
    }
  );
}
function initDom() {
  dom.appContent = document.getElementById('app-content_content');
  dom.appHeader = document.getElementById('app-content_header');
  dom.info = document.getElementById('info');
  dom.valid = document.getElementById('valid');
  dom.answer = document.getElementById('answer');
  dom.try = document.getElementById('try');
  dom.answer_student = document.getElementById('answer_student');
  dom.content = $('.content');
  dom.example = $('.contenteditable-example');
  dom.bloc_1 = document.getElementById('bloc_1');
  dom.bloc_2 = document.getElementById('bloc_2');
  dom.bloc_3 = document.getElementById('bloc_3');
  dom.bloc_4 = document.getElementById('bloc_4');
  dom.bloc_5 = document.getElementById('bloc_5');
  dom.bloc_6 = document.getElementById('bloc_6');
  dom.bloc_7 = document.getElementById('bloc_7');
  dom.bloc_multiple = document.getElementById('bloc_multiple');
  dom.bloc_multiple_1 = document.getElementById('multiple_1');
  dom.bloc_multiple_2 = document.getElementById('multiple_2');
  dom.bloc_multiple_3 = document.getElementById('multiple_3');
  dom.bloc_multiple_4 = document.getElementById('multiple_4');
  dom.examples = document.querySelectorAll('.contenteditable-example')
}

function toggleValid(isShow) {
  if (isShow) {
    dom.valid.classList.remove('isHide');
  } else {
    dom.valid.classList.add('isHide');
  }
}

function updateData(index, value,type) {
  if(type==="example"){
   
    data[index].example = value;
  } else {
    data[index].txt = value;
  }
  
  
}

function checkValid(index, value, type) {
  _line1.position();
  _line2.position();
  _line3.position();

  if (inPlaced === toPlaced) {
    toggleValid(true);
  } else {
    toggleValid(false);
  }
}

function validate() {
  $($(dom.content).parent()).removeClass('bad');
  $($(dom.content).parent()).removeClass('good');

  if ($(dom.content[0]).text() === answers[0].txt) {
    $(dom.content[0]).parent().addClass('good');
    isGood += 1;
  } else {
    $(dom.content[0]).parent().addClass('bad');
  }
  if ($(dom.content[1]).text() === answers[1].txt) {
    $(dom.content[1]).parent().addClass('good');
    isGood += 1;
  } else {
    $(dom.content[1]).parent().addClass('bad');
  }
  if ($(dom.content[2]).text() === answers[2].txt) {
    $(dom.content[2]).parent().addClass('good');
    isGood += 1;
  } else {
    $(dom.content[2]).parent().addClass('bad');
  }
  if ($(dom.content[3]).text() === answers[3].txt) {
    $(dom.content[3]).parent().addClass('good');
    isGood += 1;
  } else {
    $(dom.content[3]).parent().addClass('bad');
  }
  if ($(dom.content[4]).text() === answers[4].txt) {
    $(dom.content[4]).parent().addClass('good');
    isGood += 1;
  } else {
    $(dom.content[4]).parent().addClass('bad');
  }
  if ($(dom.content[5]).text() === answers[5].txt) {
    $(dom.content[5]).parent().addClass('good');
    isGood += 1;
  } else {
    $(dom.content[5]).parent().addClass('bad');
  }
  if ($(dom.content[6]).text() === answers[6].txt) {
    $(dom.content[6]).parent().addClass('good');
    isGood += 1;
  } else {
    $(dom.content[6]).parent().addClass('bad');
  }
  if ($(dom.content[7]).text() === answers[7].txt) {
    $(dom.content[7]).parent().addClass('good');
    isGood += 1;
  } else {
    $(dom.content[7]).parent().addClass('bad');
  }

  if (isGood < data.length && hasTry === 0) {
    dom.try.classList.remove('isHide');
    dom.answer.classList.add('isHide');
    dom.info.innerHTML = '<i class="oups">Vous avez fait des erreurs, réessayer.<i>';
  }
}

function tryAgain() {
  for (var i = 0; i < $('.word').length; i++) {
    enableItemDrag($(dom.content[i]));
  }
  dom.try.classList.add('isHide');
  hasTry = 1;
  dom.info.innerHTML =
    '<i class="">Pour conserver votre schéma-bilan, vous pouvez faire une capture de votre écran.<i>';
  toPlaced = $('.ui-droppable').not('.good').length;
  inPlaced = 0;
}

function enableItemDrag(item) {
  if (item.parent().hasClass('bad')) {
    item.parent().removeClass('bad');
    for (var i = 0; i < $('.word').length; i++) {
      if (
        item.parent().find('.delete').data('drag') &&
        $($('.word')[i])[0] === item.parent().find('.delete').data('drag')[0]
      ) {
        $($('.word')[i]).draggable('enable');
        $($('.word')[i]).animate({ top: 0, left: 0 }, 'fast');
        $($('.word')[i]).css({ pointerEvents: 'inherit' });
        $($('.word')[i]).draggable('option', 'revert', true);
      }
    }
    item.parent().find('.delete').data('drag', '');
    item.parent().find('.delete').data('drop', '');
    item.parent().droppable('enable');
    item.text('?');
  }
}

function showAnswer(isStudent = false) {
  if (isStudent) {
    dom.answer.classList.remove('isHide');
    dom.answer_student.classList.add('isHide');
    showAnswerStudent();
    for(var i=0; i <  dom.examples.length;i++){
    
      dom.examples[i].setAttribute('contenteditable', false);
      dom.examples[i].innerHTML=data[i].example
    }
  } else {
    dom.answer.classList.add('isHide');
    dom.answer_student.classList.remove('isHide');
    $(dom.content[0]).text(answers[0].txt);
    $(dom.content[1]).text(answers[1].txt);
    $(dom.example[0]).text(answers[1].example);
    $(dom.content[2]).text(answers[2].txt);
    $(dom.example[1]).text(answers[2].example);
    $(dom.content[3]).text(answers[3].txt);
    $(dom.content[4]).text(answers[4].txt);
    $(dom.content[5]).text(answers[5].txt);
    $(dom.content[6]).text(answers[6].txt);
    $(dom.content[7]).text(answers[7].txt);
    $(dom.example[2]).text(answers[7].example);
    for(var i=0; i <  dom.examples.length;i++){
    
      dom.examples[i].setAttribute('contenteditable', false);
      dom.examples[i].innerHTML=examples[i]
    }
  }
  validate();
  _line1.position();
  _line2.position();
  _line3.position();
}

function handleCardDrop(event, ui) {
  var txt = ui.draggable.text();
  ui.draggable.draggable('disable');
  ui.draggable.position({ of: $(this), my: 'center top', at: 'center top' });
  $(this).find('.content').text(txt);
  $(this).find('.delete').css({ display: 'flex' });
  $(this).find('.delete').data('drag', ui.draggable);
  $(this).find('.delete').data('drop', $(this));
  $(this).droppable('disable');

  inPlaced += 1;
  checkValid();
}

function initDragItem(item) {
  item.draggable('enable');
  item.animate({ top: 0, left: 0 }, 'fast');
}

function disableDragItem() {
  $('.word').css({ pointerEvents: 'none' });
  $('.delete').css({ display: 'none' });
}

function showAnswerStudent() {
  for (var i = 0; i < data.length; i++) {
    $(dom.content[i]).text(data[i].txt);
  }
}

function saveAnswerStudent() {
  for (var i = 0; i < data.length; i++) {
    data[i].txt = $(dom.content[i]).text();
  }
}
function init() {
  $('.word').draggable({
    cursor: 'move',
    revert: true,
    revertDuration: 100,
  });

  $('.drop').droppable({
    accept: '.word',
    hoverClass: 'hovered',
    drop: handleCardDrop,
  });
}
function initEvent() {
  $('.delete').on('click', function (evt) {
    var drag_in_place = $(evt.currentTarget).data('drag');
    var drop_in_place = $(evt.currentTarget).data('drop');
    drop_in_place.find('.delete').data('drag', '');
    drop_in_place.find('.delete').data('drop', '');
    drop_in_place.find('.content').text('?');
    drop_in_place.find('.delete').css({ display: 'none' });
    drop_in_place.droppable('enable');
    initDragItem(drag_in_place);
    inPlaced -= 1;
    checkValid();
  });
  dom.answer.addEventListener('click', function () {
    showAnswer(false);
  });
  dom.answer_student.addEventListener('click', function () {
    showAnswer(true);
  });
  dom.try.addEventListener('click', function () {
    tryAgain();
  });

  for(var i=0;i<dom.examples.length;i++){
    dom.examples[i].addEventListener("input", function (event) {
    updateData(Number(event.target.dataset.id), event.target.innerText,'example');
  });
  }

  dom.valid.addEventListener('click', function () {
    dom.answer.classList.remove('isHide');
    dom.valid.classList.add('isHide');
    disableDragItem();
    saveAnswerStudent();
    validate();
  });
}

function initApp() {
  initDom();
  init();
  initEvent();
  createLines();
  dom.info.classList.remove('isHide');
}

window.addEventListener('load', initApp);
