#include "DHT.h";     // Appel de la librairie DHT
#define DHTPIN 7      // Données "DHTPIN" de DHT-22 sur broche 7
#define DHTTYPE DHT22 // Défnition du type de capteur DHT 22

DHT dht(DHTPIN, DHTTYPE); // Initialisation du capteur DHT

float theta,hum;      // Définition des variables température et humidité

void setup() {
  Serial.begin(9600); // Initialisation du moniteur série à 9600 bauds
  dht.begin();        // Initialisation de la librairie dht
}

void loop() {
   delay(2000);  // Delai en ms pour stabilisation du capteur
   theta = dht.readTemperature(); // Mesure de la temperature en °C
   hum = dht.readHumidity();      // Mesure du taux d'humidité en %

// Affichage de la mesure dans le moniteur série
   Serial.print("Température : ");
   Serial.print(theta);
   Serial.print(" °C,");
   Serial.print(" Humidité : ");
   Serial.print(hum);
   Serial.println(" %"); 
}
