#!/usr/bin/env python3
# -*- coding: utf-8 -*-
import numpy as np
from matplotlib import pyplot as plt

#-----Génération des coordonnées du projectile ---------------------
t = np.linspace(0.0,3.0,11) # Définition du domaine des dates (en s)
x = 10.0*t                  # Définition des abscisses (en m)
y = -4.9*t**2+14.9*t        # Définition des ordonnées (en m)

#-----Figure représentant la trajectoire y=f(x) --------------------
plt.figure('Vecteurs vitesse et variation de vitesse du projectile')
plt.title('Vecteurs vitesse et variation de vitesse du projectile')
plt.xlabel('x(en m)')
plt.ylabel('y(en m)')
plt.plot(x,y,'ro',ms=2)
plt.axis('equal')

#-----Calculs des coordonnées des vecteurs vitesse V----------------
# définition de 2 listes pour les variables Vx et Vy  
Vx,Vy=[0],[0]

for i in range(1,10) :       
    # Coordonnées Vxi des vecteurs vitesse sur l'axe x au point i
    Vxi=(x[i+1]-x[i-1])/(t[i+1]-t[i-1])     
    Vx.append(Vxi)          # ajout de la valeur Vxi à la liste Vx     
    
    # Coordonnées Vyi des vecteurs vitesse sur l'axe y au point i
    Vyi=(y[i+1]-y[i-1])/(t[i+1]-t[i-1])     
    Vy.append(Vyi)          # ajout de la valeur Vyi à la liste Vy  

#-----Tracé d'un vecteur vitesse sur deux aux points d'indice i-1---
for i in range(2,12,2) :      
    plt.arrow(x[i-1],y[i-1],0.25*Vx[i-1],0.25*Vy[i-1],width=0.05,
    length_includes_head="true",color='g')
"""
#-----Tracé d'un vecteur variation de vitesse sur deux aux points i               
for i in range(2,10,2) :      
    ..........................................
    ..........................................
    .......................................... 
"""   
plt.show()                    

