#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# ================================================================================
# Chapitre 12 : Mouvement d'un système 
# Activité expérimentale 4 : Expérience avec un mobile autoporteur et Python, 
# code source Python niveau "initiation"
# Programme permettant de représenter les positions successives du centre d'un 
# mobile autoporteur issues d'un pointage vidéo ainsi que les vecteurs vitesse 
# et les vecteurs variation de vitesses à partir d'un fichier de données texte.      
# ================================================================================
"""
Les blocs de lignes de codes entre 2 séries de 3 guillemets sont des commentaires:
ils sont inactifs lors de l'exécution du programme.
"""

"""
Ce code source permet de représenter la trajectoire et les vecteurs vitesse
du centre du mobile autoporteur. Les lignes de codes allant de 31 à 44 permettent 
l'extraction des données du pointage et ne doivent pas être modifiées.
- Exécuter le code source pour visualiser la figure produite.
- Réaliser ensuite les taches suivantes :
    a.faire calculer les coordonnées des vecteurs variation de vitesse 
    b.représenter en bleu les vecteurs variation de vitesse tous les p points 
    c.représenter, tous les p points et en magenta, le segment joignant le centre
      M du mobile et le point d'attache O de l'ensemble fil + ressort qui indique 
      la direction de la force exercée par le ressort sur le mobile autoporteur.
Pour cela voir les questions a, b et c posées à partir de la ligne 87.    
"""
import matplotlib.pyplot as plt

# Extraction des données du fichier texte de pointage, A NE PAS MODIFIER =========
t,x,y=[],[],[] # définition de 3 listes vides pour les 3 variables t, x et y

# ouverture du fichier texte avec la méthode with 
with open("pointageMobile.txt", "r") as fichierTexte:       
   # extraction des données du fichier ligne par ligne
    i=0
    for l in fichierTexte:          
        if i > 2 : # extraction des données à partir de la 3ème ligne du fichier
            # conversion en nombre des données d d'une ligne                        
            ti,xi,yi=[float(d) for d in l.replace(",",".").split(";")]            
            # ajout des données ti, xi et yi dans les listes t, x et y       
            t.append(ti), x.append(xi), y.append(yi)   
        i=i+1        

# Option pour ne représenter qu'un vecteur vitesse tous les n points
print("")
print("Représenter :")
n=int(input('- un vecteur vitesse tous les n points, n= '))

# Tracé des points de la trajectoire y=f(x)=======================================                   
# Initialisation de la figure, nom de la fenêtre de visualisation
plt.figure('Force et vecteur variation de vitesse sur un mobile autoporteur')
plt.title('Vecteur vitesse et variation de vitesse') # titre 
plt.xlabel('x(en m)')              # légende de l'axe des abscisses
plt.ylabel('y(en m)')              # légende de l'axe des abscisses
plt.axis('equal')                  # même échelle sur les axes 

# Représentation des points de coordonnées (x(t),y(t)),rouge'r',forme'o',taille 2
plt.plot(x,y,'ro',ms=2) 

                                            
# Calculs des coordonnées des vecteurs vitesse ===================================
# Définition de 2 listes pour les variables Vxi, Vyi    
Vx,Vy=[0],[0] # Premières valeurs nulles pour l'indice i=0 non utilisé
for i in range(1,len(t)-1) :     
    # Calcul de la coordonnée Vxi du vecteur vitesse Vi sur l'axe x au point n°i
    Vxi=(x[i+1]-x[i-1])/(t[i+1]-t[i-1])            
    Vx.append(Vxi) # ajout de la valeur Vxi à la liste Vx   
    
    # Calcul de la coordonnée Vyi du vecteur vitesse Vi sur l'axe y au point n°i
    Vyi=(y[i+1]-y[i-1])/(t[i+1]-t[i-1])            
    Vy.append(Vyi) # ajout de la valeur Vyi à la liste Vy    
    

# Représentation des vecteurs vitesse tous les n points et affichage Vxi et Vyi===
print()
print("Point n°","\t Vx (en m.s-1)", "\t Vy (en m.s-1)")
for i in range(1,len(t)-2,n) :
    # Représente, au point d'indice i de coordonnées (x[i],y[i]), une flèche
    # de longueurs Vx[i]/10 sur l'axe x et Vy[i]/10 sur l'axe y    
    plt.arrow(x[i], y[i], Vx[i]/10, Vy[i]/10, width=0.0005,   
    length_includes_head="true",head_length=0.0025, head_width=0.0015, color='g')  
    # affiche les coordonnées Vxi et Vyi à 3 chiffres après la virgule
    print(i," \t",round(Vx[i],3)," \t", round(Vy[i],3))
    
# Question a =====================================================================
"""
Supprimer les guillemets des lignes 93 et 108. 
Compléter les lignes de codes désormais actives selon les consignes. 
Enregistrer et exécuter le programme.
"""
"""  
# Calculer les coordonnées des vecteurs variation de vitesse =====================
# Définition de 2 listes pour les variables deltaVx et deltaVy contenant 0,0  
# pour les indices i=0 et i=1 non utilisés 
deltaVx,deltaVy=[0,0],[0,0] 
for i in range(2,len(t)-2) :                        
    # Calculer les coordonnées deltaVxi du vecteur variation de vitesse 
    # sur l'axe x au point n°i
    ......à compléter........
    ......à compléter........ # Ajouter de la valeur deltaVxi à la liste deltaVx
    
    # Calculer les coordonnées deltaVyi du vecteur variation de vitesse 
    # sur l'axe y au point n°i
    ......à compléter........
    ......à compléter........ # Ajouter de la valeur deltaVyi à la liste deltaVy
"""
# Question b =====================================================================
"""
Supprimer les guillemets des lignes 115 et 129. 
Compléter les lignes de codes désormais actives selon les consignes.
Enregistrer et exécuter le programme.
"""
"""
# Représenter un vecteur variation de vitesse tous les p points
..à compléter..=int(input(..........à compléter..........)
  
# Représenter les vecteurs variation de vitesse et afficher les coordonnées=======
print()
print("Point n°","\t deltaVx (en m.s-1)", "\t deltaVy (m.s-1)")
for i in range(2,len(t)-2,p) :        
    # Représenter, au point d'indice i de coordonnées (x[i],y[i]), une flèche
    # de longueurs deltaVx[i]/10 sur l'axe x et deltaVy[i]/10 sur l'axe y   
    plt.arrow(...................à compléter...................................   
    .............................à compléter....................................) 
    # Afficher les coordonnées deltaVxi et delatVyi à 3 chiffres après la virgule
    print(.......................à compléter..............................)
"""   
    # Question c =================================================================
"""
    Supprimer les guillemets des lignes 136 et 141.
    Compléter la ligne de code 140 désormais active selon les consignes.
    Enregistrer et exécuter le programme.
"""

    # Représenter, en magenta, le segment en pointillé de couleur 'c', d'épaisseur 
    # '0.3', joignant le point d'attache O de l'ensemble fil + ressort au support 
    # de coordonnées (xo,yo) au centre M du mobile de coordonnées(xm,ym)    
    plt.plot([xp,xm],[yp,ym],'c--',lw='0.3') # MODIFIER xo,xm,yo,ym et c       

plt.show()

