#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# =============================================================================
# 1C17 Activité 4                                                    INITIATION
# Réaliser : Simulation de la propagation d'une onde sinusoïdale
# =============================================================================

import numpy  as np
from matplotlib import pyplot as plt
from matplotlib import animation as anim
from math import pi

# =============================================================================
# Question 2 c
# =============================================================================
"""
Compléter les lignes 24 et 25 puis exécuter le programme pour simuler la
propagation des vagues destinées aux surfeurs expérimentés du parc à vagues à la
fréquence maximale.
"""
x = np.linspace(0,100,256) # Domaine des abcisses (en m)
v = 4.7                    # Célérité (en m/s)
delta_t = (x[1]-x[0])/v    # Intervalle de temps (en s)

A = ...A compléter...      # Amplitude (en m)
T = ...A compléter...      # Période (en s)

# Initialisation de la figure
figure = plt.figure('Propagation d\'une onde sinsusoïdale')
plt.axis([0,100,-10,10])
plt.xlabel('$x$ (en m)')
plt.ylabel('$y$ (en m)')

# Initialisation du graphe tracé mis à jour au fur et à mesure
courbe, = plt.plot([],[],'g-',lw=1.5) # Graphe sans point

# Fonction fixant l'arrière de l'animation présent à chaque image
def init():
    courbe.set_data([],[])
    return courbe,

# Création de la fonction 'onde' appelée à chaque nouvelle image i
def onde(i): 
    t = i*delta_t
    y = A*np.cos((2*pi/T)*t-(2*pi/(v*T))*x)
    courbe.set_data(x,y)       # Mise à jour du graphe
    return courbe,

# Animation de la figure affichant onde(i), à chaque image i, pour i
# entier de 0 à 255 avec un délai entre 2 images égal à interval en ms
# blit=True indique que seuls les éléments modifiés sont redessinés
animation = anim.FuncAnimation(figure,onde,init_func=init,frames=256,
                               blit=True,interval=delta_t*1000, repeat=False)
