import numpy as np
import matplotlib.pyplot as plt

g = 9.81                  # intensité de la pesanteur terrestre en N/kg
m = 1200                  # masse de la voiture en kg
z_0 = 100                 # altitude au debut du freinage en m

v_0=float(input('Entrer la vitesse initiale en km/h : v_0='))
pente=float(input('Entrer la pente en % : pente='))
mu=float(input('Entrer le coefficient de frottement : mu='))

from math import asin

alpha = asin(pente/100) # angle de la pente en radian

d = np.linspace(0,150,151)   # definition du domaine des abcisses
from math import cos

def Em(d):                # definition de la fonction à représenter
    return 0.5*m*(v_0/3.6)**2+m*g*z_0-mu*m*g*d*cos(alpha)

from math import sin

def Epp(d):                # definition de la fonction à représenter
    return m*g*(z_0-d*sin(alpha))

def Ec(d):                # definition de la fonction à représenter
    return Em(d)-Epp(d)


plt.title('Energies en fonction de d') # titre des courbes
plt.xlim(0,max(d))
plt.xlabel('d (m)')          # legende axe des abcisses
plt.ylabel('Energie (kJ)')   # legende axe des ordonnées

plt.plot(d,Em(d)/1000,'r', label='Em') # graphique des points (d,Em(d)) en rouge
plt.plot(d,Epp(d)/1000,'b', label='Epp') # graphique des points (d,Epp(d)) en bleu
plt.plot(d,Ec(d)/1000,'g', label='Ec') # graphique des points (d,Ec(d)) en vert
plt.legend()                 # ecrit les labels avec les couleurs
plt.grid()                   # insere une grille
plt.show()                   # affiche les graphiques

