import numpy as np 
import matplotlib.pyplot as plt
from math import sqrt # appel de la fonction racine

m=90           # masse du parachutiste en kg
g=9.81         # intensité de la pesanteur terrestre en N/kg
z_0=3000       # altitude de départ en m
z_p=2000       # altitude d'ouverture du parachute en m
v_0=0          # valeur de la vitesse initiale de chute

h=np.linspace(0,z_0-z_p,1001) # définition des abscisses (en m)

def v(h_i):         # définition de la fonction à représenter
    Em_0=1/2*m*v_0**2+m*g*z_0
    Epp_h=m*g*(z_0-h_i)
    Ec_h=Em_0-Epp_h
    return sqrt(2*Ec_h/m)
 
v = [v(h_i) for h_i in h]  # définition des ordonnées (en m/s) 
  
plt.plot(h,v)# graphique des points de coordonnées dans h et v
plt.xlabel('Hauteur de chute (en m)') # légende axe abscisses
plt.ylabel('Valeur de la vitesse de chute (en m/s)') 
                                   #légende axe des ordonnées
plt.grid()          # insère une grille
plt.title('v=f(h)') # titre de la courbe
plt.show( )         # affiche la figure

