#include "DHT.h";        // Inclure la librairie DHT.h
#define EMISSION  10     // EMISSION sur broche 10
#define ECHO      13     // ECHO sur broche 13
#define DHTPIN 7         // Données "DHTPIN" de DHT-22 sur broche 7
#define DHTTYPE DHT22

DHT dht(DHTPIN, DHTTYPE);// Initialiser le capteur DHT
float hum, theta, v_HT;  // Définir les variables utilisées dans setup et dans loop

void setup() {
  Serial.begin (9600);         // Initialiser le moniteur série à 9600 bauds
  pinMode(EMISSION, OUTPUT);   // Déclarer la broche EMISSION en OUTPUT
  digitalWrite(EMISSION, LOW); // Imposer l’état LOW à la broche EMISSION au repos
  pinMode(ECHO, INPUT);        // Déclarer la broche ECHO en INPUT
  dht.begin();                 // Initialiser la librairie dht
  delay(2000);                 // Imposer un délai de 2000ms
  
// Mesurer le taux d'humidité « hum » et la température « theta » grâce au dht22
  hum = dht.readHumidity();   
  theta = dht.readTemperature();
// Calculer la célérité du son v_HT en m/s en fonction de theta et de hum
 A compléter

// Afficher les mesures et v_HT dans le moniteur série
  Serial.print(hum);
  Serial.print(" %;    ");
  Serial.print(theta);
  Serial.print(" °C;    v_HT = ");
  Serial.print(v_HT);
  Serial.println(" m/s");
}

void loop() {
 // Envoyer une salve d'ultrasons de 10 us depuis la broche Emission
  delayMicroseconds(2);         //Delai de 2us
  digitalWrite(EMISSION, HIGH); //Début de l'emission de la salve
  delayMicroseconds(10);        //Delai de 10us
  digitalWrite(EMISSION, LOW);  //Fin de l'émission de la salve

// Mesurer deltat en microseconde entre l'émission et l'écho avec la fonction pulseIn()
  noInterrupts();
  long deltat = pulseIn(ECHO, HIGH);
  interrupts();

// Calculer la distance d_340 en cm à partir de deltat si la célérité du son vaut 3,4E2 m/s
 A compléter
 // Calculer la distance d_HT en cm à partir de deltat si la célérité du son vaut v_HT
 A compléter
 
// Afficher dans le moniteur série les 2 mesures d_340 et d_HT en cm
// sur une seule ligne et séparées par un point virgule
  Serial.print(d_340);
  Serial.print(";");
  Serial.println(d_HT);
  delay(500);                  // Imposer un délai de 500ms
}
