import numpy  as np
from matplotlib import pyplot as plt
from matplotlib import animation as anim

x = np.linspace(0,4,256) # Domaine des abcisses (en m)
delta_t = 0.01           # Intervalle de temps (en s)

# Initialisation de la figure
figure = plt.figure('Propagation d\'une onde sinsusoïdale')
plt.axis([0,4,-3,3])
plt.xlabel('$x$ (en m)'), plt.ylabel('$y$ (en m)')

# Initialisation du graphe tracé mis à jour au fur et à mesure
courbe, = plt.plot([],[],'g-',lw=1.5) # Graphe sans point

# Création de la fonction 'onde' appelée à chaque nouvelle image i
def onde(i): 
    t = i*delta_t
    y = 2*np.cos((2*np.pi/0.85)*(x-2.3*t))
    courbe.set_data(x,y)       # Mise à jour du graphe
    return courbe,

# Animation de la figure affichant onde(i), à chaque image i, pour i
# entier de 0 à 255 avec un délai entre 2 images égal à interval en ms
animation = anim.FuncAnimation(figure,onde,frames=256,blit=True,
                               interval=delta_t*1000,repeat=False)

