#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# ==================================================================================
# Chapitre 12 : Mouvement d'un système 
# Exercice 23 p 251 : Modéliser l'influence de la masse 
# code source Python niveau "initiation" 
# Programme permettant de modéliser le mouvement d'un mobile de masse variable, 
# soumis à une unique force constante, sur une table horizontale. Le programme 
# permet de représenter les positions et les vecteurs variations de vitesse de deux
# masses m1 et m2 soumises à une même force. Cette représentation graphique simulée
# avec des masses différentes permet de mettre en évidence l'influence de la masse.      
# ==================================================================================
"""
Les blocs de lignes de codes entre 2 séries de 3 guillemets sont des commentaires:
ils sont inactifs lors de l'exécution du programme.
"""
"""
1.Exécuter le code source pour visualiser la figure produite. Justifier que seules 
  les coordonnées sur l'axe x soient prises en compte pour les calculs de vitesse. 
2.Réaliser ensuite les taches suivantes :
    a.réaliser ensuite plusieurs simulations en faisant varier la norme de la force 
      exercée sur la masse m1 et conclure sur l'influence de la norme de la force 
      sur le vecteur variation de vitesse.   
    b.compléter le code source à partir de la ligne 55 pour pouvoir représenter, 
      de couleur cyan, les vecteurs variation de vitesse du mobile de masse m2.      
    c.réaliser plusieurs simulations en faisant varier les  masses m1 et m2 pour des 
      forces de même norme égale à 0,38 N appliquées à ces masses. Conclure.    
"""
import numpy as np
from matplotlib import pyplot as plt

# ==== Définition des variables et constantes nécessaires ==========================
dt=0.025 # Valeur de l'intervalle de temps constant et égale à 25 ms 
F =float(input('Valeur F de la force (entre 0,20 et 0,50 N): F = ? '))  
m1=float(input('Valeur de la masse m1 (entre 0,100 et 0,500 g): m1 = ? '))
m2=float(input('Valeur de la masse m2 (entre 0,100 et 0,500 g): m2 = ? '))
N =20     # Nombre maximal de points à représenter 

# ==== Génération des coordonnées des masses ponctuelles m1 et m2 ================== 
t = np.linspace(0,N*dt,N)         # Définition du domaine des dates (en s)
x1 = 100*((F/(2*m1))*t**2)        # Définition des abscisses x1 (en cm)
y1 = 100*(0*t + 0.003)            # Définition des ordonnées y1 (en cm)
x2 = 100*((F/(2*m2))*t**2)        # Définition des abscisses x2 (en cm)
y2 = 100*(0*t)                    # Définition des ordonnées y2 (en cm)
# distance en cm pour alléger la représentation graphique 

# ==== Figures représentant les trajectoires y1=f(x1 et y2=f(x2) ===================
plt.figure('Positions et vecteurs variation de vitesse de m1 et m2')
plt.title('Vecteurs variation de vitesse de m1 et m2'+' (F='+str(round(F,2))+' N)') 
plt.xlabel('x(en cm)')
plt.ylabel('y(en cm)')
plt.plot(x1,y1,'bo',ms=2,label='masse m1='+str(m1)+' kg')
plt.plot(x2,y2,'ro',ms=2,label='masse m2='+str(m2)+' kg')
plt.axis([-0.1,1.9,-0.5,0.75])

# ==== Calculs des coordonnées des vecteurs vitesse V1 et V2 =======================
# définition de 2 listes pour les variables Vx1 et Vy1  
Vx1,Vx2=[0],[0]
for i in range(1,len(t)-1) :       
    # calcul des coordonnées Vx1i des vecteurs vitesse sur l'axe x au point n°i
    Vx1i=(x1[i+1]-x1[i-1])/(t[i+1]-t[i-1])     
    Vx1.append(Vx1i)                # ajout de la valeur Vx1i à la liste Vx1     
"""      
    # calculer les coordonnées Vx2i des vecteurs vitesse sur l'axe x au point n°i
    Vx2i=........à compléter.............        
    ..à compléter..                 # ajouter de la valeur Vx2i à la liste Vx2   
"""  
# ==== Tracé des vecteurs variation de vitesse deltaV1 et deltaV2 ==================                  
for i in range(2,len(t)-2) : 
    # Représente, au point d'indice i de coordonnées (x1[i],y1[i]), une flèche
    # de longueur dt*(Vx1[i+1]-Vx1[i-1]) sur l'axe x 
    plt.arrow(x1[i],y1[i],dt*(Vx1[i+1]-Vx1[i-1]),0,width=0.005,
    length_includes_head="true",head_length=0.04,head_width=0.03,color='m')     
"""  
    # Représente, au point d'indice i de coordonnées (x2[i],y2[i]), une flèche
    # de longueur dt*(Vx2[i+1]-Vx2[i-1]) sur l'axe x 
    ................................à compléter.....................................
    ................................à compléter.....................................
    
    # affichage des valeurs des vecteurs variation de vitesse dans l'interpréteur
    # uniquement pour les vecteurs représentés dans la fenêtre graphique
    if(x1[i]<=1.9 or x2[i]<=1.9) :
        print("V1 =",round((Vx1[i+1]-Vx1[i-1]),2),"cm.s-1   V2 =",
        round((Vx2[i+1]-Vx2[i-1]),2),"cm.s-1")
    
#-affichage de l'échelle de représentation des vecteurs vitesse - A NE PAS MODIFIER
plt.text(0,-0.40,'Echelle du vecteur variation de vitesse :', color='green')
plt.text(1.25,-0.35,10, color='green') # affichage 10 cm/s
plt.text(1.32,-0.35,' cm.s$^{-1}$', color='green')
# flèche de longueur correspondant à 0,20 m/s
plt.arrow(1.27,-0.4, dt*10, 0,width=0.005,
              length_includes_head="true", head_length=0.04,
              head_width=0.03, color='g')    
"""
plt.legend()  
plt.show()                    