
const int nbMesures = 300;     // nombre de mesures 
float TensionCapteur ;         // définit la variable correspondant à la tension délivrée par le capteur
float Pression      ;          // définit la variable pression issue de la conversion de la tension de sortie en pression
float mesure[nbMesures];       // tableau contenant les mesures
float somme ;                  // somme des éléments du tableau
float moyenne;                 // moyenne
int BrocheEntree = A0;         // Broche de connexion du capteur de pression
float sigma2;                  // carré de l'écart type expérimental
float u  ;                     // incertitude sur la moyenne des mesures
const float decalage = 0.0;    // offset à ajuster sur la pression atmoshérique
 
void setup() {         // début de l'initialisation
  Serial.begin(9600) ;   // initialise la communication série entre la carte et l’ordinateur et fixe ici 9600 bits échangés par seconde
   Serial.println("Mesure de pression avec le capteur MPX 4250");  //le moniteur série affiche ce message quand l'acquisition débute
  Serial.println("La mesure résulte d'une moyenne et une incertitude de type A est donnée"); 
  Serial.println("***********************************") ;//le moniteur série affiche ce message quand l'acquisition débute
  }                       // fin du setup

// cette boucle va se répéter sans arrêt
void loop() { // début de la boucle

// boucle de remplissage du tableau et sommation des éléments du tableau pour le calcul de la moyenne
  Serial.println("*");
  Serial.println("*   Série de mesures");
  for (int i=0; i < nbMesures; i++){
    TensionCapteur = 5.0*analogRead(BrocheEntree)/1023.0 ;    // convertit le nombre mesuré sur le port A0 en volts  
                                                              // et l’attribue à la variable TensionCapteur                                   
    Pression = (1/0.000369)*(TensionCapteur/5.1 - 0.004) + decalage;  // convertit la tension en pression en utilisant
                                                                      // la fonction de transfert indiquée dans la notice 
    mesure[i] = Pression;     // Stocke la valeur de la pression dans le tableau de mesures
    somme = somme + Pression; // Fait la somme de toutes les mesures
   
    Serial.print(Pression);
    Serial.print(" ; ");
    };

  moyenne = somme/nbMesures; // calcule la valeur moyenne des mesures

// boucle de calcul du carré de l'écart-type expérimental
  for (int i=0; i < nbMesures; i++){
   sigma2 =  sigma2 + (1/(nbMesures-1.0))*((mesure[i]-moyenne)*(mesure[i]-moyenne));
   };
  u = sqrt(sigma2/nbMesures); // calcul de l'incertitude de type A
  Serial.println(); Serial.println();
  Serial.print("Moyenne sur ") ; 
  Serial.print(nbMesures) ; 
  Serial.println(" mesures") ; 
  Serial.print("m = ") ; 
  Serial.print(moyenne);
  Serial.println("hPa");
  Serial.println("Ecart-type expérimental");
  Serial.print("sigma = ");
  Serial.print(sqrt(sigma2));
  Serial.println("hPa");
  Serial.println("Incertitude de type A ");
  Serial.print("u = ");
  Serial.print(u);
  Serial.println("hPa");
  Serial.println("***********************************") ; 


 // réinitialisation des valeurs
  somme = 0;
  sigma2 = 0; 
  delay(10000) ;                                    // attend 10 s avant la prochaine mesure 
  }
// fin de la boucle principale
