from microbit import *  # Import de la bibliothèque micro:bit
nbMesures = 300         # Initialise les variables
decalage = 0
sigma2 = 0
calcul = 0
somme = 0
mesure = []
while True:             # démarre une boucle infinie
    for i in range(nbMesures):     # démarre une boucle de nbMesures
        TensionMesuree = 3.3*pin0.read_analog()/1023.0  # convertit le nombre mesuré sur la broche 0 en volts
                                                        # et l'attribue à la variable TensionMesuree
        Pression = (1/3.69e-4)*(TensionMesuree/5.1 - 4e-3) + decalage   # convertit la tension en pression en utilisant
                                                                        # la fonction de transfert indiquée dans la notice
        mesure = mesure + [Pression]    # stocke la valeur de la pression dans le tableau de mesures
        somme = somme + Pression        # fait la somme de toutes les mesures
    moyenne = somme / nbMesures         # calcule la valeur moyenne des mesures

    # boucle de calcul du carré de l'écart-type expérimental
    for i in range(nbMesures):
        calcul = 1/(nbMesures-1.0)*(mesure[i]-moyenne*(mesure[i]-moyenne))
        sigma2 = sigma2 + calcul
    u = (sigma2/nbMesures)**0.5         # calcul de l'incertitude de type A
                                        # **0.5 correspond à puissance 1/2 donc
                                        # **0.5 calcule la racine carrée
    # affichage des résultats
    print('***********************')
    print('* Serie de mesures : ')
    print('*')
    print(mesure)
    print(' ')
    print('Moyenne sur', nbMesures, ' mesures')
    print('m = ', moyenne, ' hPa')
    print('Ecart-type experimental :')
    print('Sigma =', sigma2**0.5, ' hPa')
    print('Incertitude de type A')
    print('u = ', u, ' hPa')
    print('***************')
    somme = 0       # réinitialisation des valeurs somme et sigma2
    sigma2 = 0
    mesure = []
    sleep(10000)    # attend 10 s avant la prochaine mesure