byte NOIR = 0b000;          // Définit les couleurs
byte ROUGE = 0b100;         // ce sont des valeurs binaires
byte VERT = 0b010;          // par exemple le code :
byte BLEU = 0b001;          // 0b101
byte MAGENTA = 0b101;       // signifie 101 : on mettra
byte JAUNE = 0b110;         // la première broche (rouge) à l'état haut (1)
byte CYAN = 0b011;          // la deuxième broche (vert)  à l'état bas (0)
byte BLANC = 0b111;         // la troisième broche (bleu) à l'état haut (1)

int BrocheLedRouge = 8;    // Définit les broches
int BrocheLedVerte = 9;   // sur lesquelles on branchera
int BrocheLedBleue = 10;   // la LED RVB

void setup() {
  pinMode(BrocheLedRouge, OUTPUT);     // Initialise les broches
  pinMode(BrocheLedVerte, OUTPUT);
  pinMode(BrocheLedBleue, OUTPUT);
  AfficheCouleur(NOIR);
}

void loop() {
  AfficheCouleur(ROUGE);  // Affiche la couleur rouge
  delay(1000);            // Attend 1000 ms = 1 s
  AfficheCouleur(VERT);
  delay(1000);
  AfficheCouleur(BLEU);
  delay(1000);
  AfficheCouleur(CYAN);
  delay(1000);
  AfficheCouleur(JAUNE);
  delay(1000);
  AfficheCouleur(MAGENTA);
  delay(1000);
  AfficheCouleur(BLANC);
  delay(1000);
}

void AfficheCouleur (byte couleur) {  // Permet l'affichage des couleurs
 digitalWrite(BrocheLedRouge, bitRead(couleur, 0));
 digitalWrite(BrocheLedVerte, bitRead(couleur, 1));
 digitalWrite(BrocheLedBleue, bitRead(couleur, 2));
}
