// Affichage d'un smiley en couleur sur un affficheur à LED RVB
#include <Colorduino.h>     //Inclut la bibliothèque de fonctions liées à l'afficheur

// Dessin du Smiley 
int dessin[8][8] = {
 {0,0,1,1,1,1,0,0},         // Le code est le suivant :
 {0,1,1,1,1,1,1,0},         // 0 : pixel éteint
 {1,1,0,1,1,0,1,1},         // 1 : pixel jaune
 {1,1,1,1,1,1,1,1},         // 2 : pixel rouge
 {1,0,1,1,1,1,0,1},
 {1,1,0,0,0,0,1,1},
 {0,1,1,2,2,1,1,0},
 {0,0,1,1,1,1,0,0}
 };

int x,y;   // Déclaration de variables x et y (nombres entiers)
int r,v,b; // Déclaration de variables r, v et b (nombres entiers)
  
void setup()
{
  Colorduino.Init(); // initialisation de l'afficheur
  unsigned char BalanceBlanc[3] = {36,63,63}; // initialise correctement les couleurs
  Colorduino.SetWhiteBal(BalanceBlanc); // initialise correctement les couleurs
}

void loop()
{
  for(y = 0; y < 8; y++)      // Parcourt chaque ligne
    for(x = 0; x < 8; x++) {  // Parcourt chaque colonne
      {
      switch(dessin[x][y])    // selon la valeur lue dans le tableau dessin(x,y)
       {
        case 0: r=0; v=0; b=0; break;       // si la valeur vaut 0, ne pas l'allumer (rouge=vert=bleu=0)
        case 1: r=255; v=255; b=0; break;   // si la valeur vaut 1, l'allumer en jaune (rouge=vert= 255 et bleu=0)
        case 2: r=255; v=0; b=0; break;     // si la valeur vaut 2, l'allumer en rouge (rouge=255 et vert=bleu=0)
       }
  Colorduino.SetPixel(x, y, r, v, b);   // Envoie les valeurs de r, v  et b au pixel de coordonnées x et y.
  
     }
  }
  Colorduino.FlipPage(); // Affiche l'image
}
