#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# ==============================================================================
# 1C03 Exercice 46 page 76                                            CORRECTION
# Programme permettant de déterminer l'état final d'un système siège d'une
# transformation chimique considérée comme totale ainsi que l'avancement maximal 
# de la réaction d'équation donnée à partir d'un état initial connu.
# ==============================================================================

# Affectation de la liste des nombres stoechiométriques associés aux réactifs :
a=[2,1]
# Affectation de la liste des nombres stoechiométriques associés aux produits :
b=[1,3]

# Affectation de la liste des quantités initiales des réactifs :
nR=[3.0,2.0]
# Affectation de la liste des quantités initiales des produits :
nP=[0,0]

# Initialisation de l'avancement :
x=0
# Affectation de l'intervalle d'avancement :
dx=0.01

# Boucle simulant l'avancement progressif de la transformation,
# tant que les quantités des deux réactifs restent positives :
while nR[0]>0 and nR[1]>0:
    x+=dx             # augmentation de l'avancement de dx
    nR[0]-=a[0]*dx    # diminution de n(R1)
    nR[1]-=a[1]*dx    # diminution de n(R2)
    nP[0]+=b[0]*dx    # augmentation de n(P1)
    nP[1]+=b[1]*dx    # augmentation de n(P2)

# Affichage de la valeur de l'avancement final, maximal :
print("Si la réaction est totale, alors xf = xmax =",'{:.2f}'.format(x),"mol.")

# Affichage des quantités restantes à l'EF en chacun des réactifs (avec boucle) :
for i in range(2):
    print("La quantité finale du réactif R"+str(i+1)+" vaut :",'{:.2f}'.format(nR[i]),"mol")

# Affichage des quantités formées à l'EF en chacun des produits (sans boucle) :
print("La quantité finale du produit P1 vaut :",'{:.2f}'.format(nP[0]),"mol")
print("La quantité finale du produit P2 vaut :",'{:.2f}'.format(nP[1]),"mol")
