from matplotlib import pyplot as plt
from math import ceil

n=7         # Nombre de points décrivant une impulsion
Delta_t=8   # ∆t entre 2 positions successives (en ms)
T=100       # Période du signal (en ms)
tmax=180    # Date de fin (en ms)

# Fonction représentant un motif de durée T commençant à t0
def motif(t0,T):
    """t0=date de début du motif en ms, T=période en ms"""
    t = [t0+Delta_t*i for i in range(n)]
    y = [0,1,2,1,0,-1,0]
    t.append(t0+T)
    y.append(0)
    return plt.plot(t,y,'r')

# Représentation du signal périodique entre t=0 et tmax
N=ceil(tmax/T)# Nombre de périodes arrondi à l'entier supérieur
for i in range(N):
    motif(i*T,T)
plt.xlim(0,tmax)
plt.grid()
plt.show()

