#define EMISSION  10          // EMISSION sur broche 10
#define ECHO      13          // ECHO sur broche 13

void setup() {
  Serial.begin (9600);        //Initialisation du port série
  pinMode(EMISSION, OUTPUT);  // Broche EMISSION en OUTPUT
  digitalWrite(EMISSION, LOW);// La broche EMISSION est LOW au repos
  pinMode(ECHO, INPUT);       // Broche ECHO en INPUT
}

void loop() {
   
// Envoi d'une salve d'ultrasons de 10 us depuis la broche EMISSION
  delayMicroseconds(2);         //Delai de 2us
  digitalWrite(EMISSION, HIGH); //Début de l'emission de la salve
  delayMicroseconds(10);        //Delai de 10us
  digitalWrite(EMISSION, LOW);  //Fin de l'émission de la salve
// A la fin de l'émission de la salve, la broche ECHO passe à l'état
// HIGH et ne revient à l'état LOW qu'à la reception de la salve
  
// Mesure ∆t en microseconde entre l'émission et la réception
// en mesurant la durée de l'état HIGH de la broche ECHO
  noInterrupts();
  long deltat = pulseIn(ECHO, HIGH);
  interrupts();

// Calcul de la distance en cm à partir de deltat
// en fixant la célerité du son à 3,4E2 m/s
  float distance = ...A compléter...;
  
// Affichage du résultat dans le moniteur série
  Serial.print(deltat);
  Serial.print(" us, distance = ");
  Serial.print(distance);
  Serial.println(" cm ");
  delay(500);      //Delai de 500ms
}
