# Activité 7 - Programme pour le thermomètre électronique expérimental.
# Numérise la tension Ur présente aux bornes d'une résistance et appliquée
# entre l'entrée analogique 0 et la masse GND. Affiche la valeur de Ur
# dans le moniteur série REPL.
# Calcule la température théta en °C en utilisant le modèle tiré de la courbe
# d'étalonnage de la thermistance et affiche sa valeur.
#
from microbit import *  # Import de la bibliothèque micro:bit
# Définition des variables
x = 0           # variable pour la tension numérisée entre pin0 et GND
Ur = 0          # variable pour le calcul de la tension numérisée en V
theta = 0       # variable pour le calcul de la température mesurée en °C
while True:     # démarre une boucle infinie
    x = pin0.read_analog()  # numérisation de la tension de l'entrée 0
    Ur = 3.3*x/1023         # calcul de la  tension Ur à partir de x
    # affichage des résultats
    print(' ')  # Passe une ligne
    print('U0 = ', Ur, ' V')
    theta = 1.74-1.85*Ur+4.35*Ur*Ur  # Fonction température en fonction de Ur
    print(' ', ' ? ', ' ? ')  # À compléter
    sleep(5000)         # délai de 5 s avant de revenir au début de la boucle