/* Activité 7 - Programme pour le thermomètre électronique expérimental. 
Numérise la tension Ur présente aux bornes d'une résistance et appliquée entre l'entrée 
analogique A0 et la masse GND. Affiche la valeur de Ur dans le moniteur série. 
Calcule la température théta en °C en utilisant le modèle tiré de la courbe 
d'étalonnage de la thermistance et affiche sa valeur.  
*/

// Définition des variables :
float x = 0;     // Variable pour la tension numérisée entre l'entrée A0 et la masse GND.
float Ur = 0;    // Variable pour le calcul de la tension numérisée en V.
float theta = 0; // Variable pour le calcul de la température mesurée en °C.

// La fonction setup s'exécute une seule fois au démarrage ou si on réinitialise la carte.
void setup() {         
// Initialise la communication série avec un débit de 9600 bits/s. 
  Serial.begin(9600);  
  }

// La fonction loop est une boucle infinie qui tourne en permanence :
void loop() {
  x = analogRead(A0);              // Numérisation de la tension présente sur l'entrée A0. 
  Ur = 5*x/1023;                   // Calcul de la tension numérisée Ur à partir de x.
  Serial.print("Tension UA0 = ");  // Affichage de la tension numérisée sur l'entrée A0
  Serial.print(Ur);                // en   
  Serial.print(" V   ");           // V.
  theta = 1.74-1.85*Ur+4.35*Ur*Ur; // Fonction température theta à écrire en fonction de Ur. 
  Serial.print("temperature = ");  // Affichage de la température.
  Serial.print(theta);             // en    
  Serial.println("  °C");          // °C. 
  delay(5000);                     // Délai de 5 s entre deux mesures successives 
}   
