# ====================================================================
# 2C16 Exercice 49 page 325                                CORRECTION
# Programme permettant de représenter et de modéliser
# la caractéristique U=f(I) d'un dipole
# ====================================================================
import numpy as np                        
from matplotlib import pyplot as plt      

# Définition de 2 listes pour les 2 variables I et U
I=[0.,0.99,2.00,2.98,3.95,4.96,5.92] # I en mA
U=[0.,1.02,2.03,3.02,4.00,5.03,6.01] # U en V

#-----Affichage des points de coordonnées (I,U): U=f(I)                 
plt.figure('Etude d\'un dipole')   # Initialisation de la figure
plt.title('Caractéristique U=f(I)')# Titre du graphe
plt.xlabel('I (en mA)')            # Légende axe I
plt.ylabel('U (en V)')             # Légende axe U
plt.axis([min(I),max(I),min(U),max(U)])# Minimum et maximum des axes
plt.plot(I,U,'r+',ms=10,label='U=f(I) exp')# Trace le nuage de points

#-----Modélisation du nuage de points par la fonction np.polyfit()
# Calcule les coefficients de la fonction modélisant le nuage
# de points et les range dans un tableau nommé Modele
Modele = np.polyfit(I,U,1)

# Affecte les coefficients du modèle aux variables a,b,c...(à choisir)               
a,b = [coef for coef in Modele]
             
# Liste des ordonnées de la modélisation
U_mod = [a*i for i in I] 

# Trace les points de coordonnées I et U_mod en bleu et reliés             
plt.plot(I,U_mod,'b-',label='U=f(I) modélisé')  

print('Expression du modèle') 
print('U(en V)=',round(a,4),'x I(en mA)')#Affiche l’équation du modèle    

plt.grid()                         # Affiche une grille
plt.legend()                       # Affiche la légende
plt.show()                         # Affiche la figure

