# Chapitre 9 : Description du mouvement 
# Activité expérimentale 6 : Guidage des avions 
# Code source Python "niveau confirmé"
# 
# ENONCE
#1. REALISER
#c) Compléter le code source pour proposer un programme permettant 
#   de représenter :
#   - les trajectoires des deux avions ;


"""
1. Copier les données du pointage dans le presse papier de l'ordinateur 
en prenant le point virgule (;) comme délimiteur et en prenant un titre des 
données sans accent. Les coller ensuite dans le fichier texte
"pointage_avions.txt" joint. Enregistrer ensuite ce fichier dans le
même dossier que ce fichier Python.   

2. Exécuter le programme pour représenter les trajectoires y1=f(x1) et 
y2=f(x2) des deux avions. 

3. Modifier le code source ci-dessous pour représenter uniquement les 5 
premières positions de chacun des deux avions (au lieu de 18 positions).

4.Modifier à nouveau le code source ci-dessous pour demander dans la console 
le nombre de positions à représenter en intégrant notamment, avant la ligne
"#ouverture du fichier texte avec la méthode with", les commandes : 
p1=int(input('Commencer la représentation des points (entre 1 et 18) à partir du point n°  '))
p2=int(input('Terminer la représentation des points (entre 1 et 18) au point n°  '))   

5. Lire ensuite les informations données en dessous de ce premier code source 
pour répondre à la suite de la question.
"""

#Début du  programme
import matplotlib.pyplot as plt

# représentation d'une sélection de suite de points de 1 à 18  
p1=1
p2=18

#-----Extraction des données du fichier texte de pointage, A NE PAS MODIFIER---
t,x1,y1,x2,y2=[],[],[],[],[] # définition de 5 listes vides pour les 5 
                             # variables t, x1, y1, x2 et y2

              
# ouverture du fichier texte avec la méthode with 
with open("pointage_avions.txt", "r") as fichierTexte:
# extraction des données du fichier ligne par ligne 
    i=0 # en langage Python, l'indice de numérotation d'un tableau commence à 0
    for l in fichierTexte:  
        if i > 2 and i >= p1+2 and i <= p2+2 : # conditions d'extraction des données
            # conversion des données d d'une ligne en 5 nombres: ti,x1i,y1i,x2i et y2i                         
            ti,x1i,y1i,x2i,y2i =[float(d) for d in l.replace(",",".").split(";")]   
            # ajout des données ti,x1i,y1i,x2i,y2i dans les listes t,x1,x2,y1 et y2       
            t.append(ti), x1.append(x1i), y1.append(y1i), x2.append(x2i), y2.append(y2i)   
        i=i+1 # on passe à la ligne suivante dans le tableau
        
#-----Tracé des points de la trajectoire y=f(x)-------                   
# initialisation de la figure, nom et taille de la fenêtre de visualisation
plt.figure('Guidage des avions',figsize=(9,7),dpi=80)
plt.title('Guidage des avions') # titre 
plt.xlabel('x(en m)')              # légende de l'axe des abscisses
plt.ylabel('y(en m)')              # légende de l'axe des ordonnées
plt.axis('equal')               # même échelle sur les axes 

# Représentation des points de coordonnées (x1(t),y1(t)),rouge'r',forme'o',taille 2, 
# reliés entre eux par de fines lignes en pointillés -- d'épaisseur 0,2 ; 
# Idem pour x2(t) et y2(t) en bleu
plt.plot(x1,y1,'ro--',ms=2,lw=0.2)
plt.plot(x2,y2,'bo--',ms=2,lw=0.2)

plt.show()

# SUITE DE L'ENONCE
#1. REALISER
#c) Compléter le code source pour proposer un programme permettant de 
#   représenter :
#   - les vecteurs vitesse des deux avions.

"""
6. Supprimer l'instruction "plt.show()" à la ligne 73 du code source 
ci-dessus ainsi que les trois guillemets à la ligne 115 juste au-dessus du 
code source suivant, intitulé "Suite du programme", et dans la dernière ligne
du code. Enregistrer puis exécuter le programme pour représenter des vecteurs 
déplacement (en magenta) et des vecteurs vitesse (plus fin et en rouge) de 
l'avion 1.

7. Ajouter deux lignes au code source ci-dessous pour représenter  
des vecteurs déplacement (en cyan) et  des vecteurs vitesse 
(plus fin et en bleu) de l'avion 2 (bleu = b ; cyan = c).

8. Ajouter trois guillemets dans différentes lignes du code source pour 
représenter uniquement :
 - les vecteurs déplacement des deux avions ;
 - les vecteurs vitesse des deux avions.
 
9. Modifier le code source ci-dessous pour représenter un vecteur vitesse
toutes les positions (au lieu d'un vecteur vitesse toutes les 2
positions).

10. Modifier à nouveau le code source ci-dessous pour demander dans la console 
les positions des tracés des vecteurs vitesse en intégrant notamment, après la 
ligne "#tracé des vecteurs toutes les k positions", la commande : 
k=int(input('Tracé des vecteurs toutes les k positions : k = '))

11. Pour finir, modifier le code source ci-dessous pour demander dans la 
console la valeur du facteur d'échelle e des vecteurs vitesse  (en conseillant 
un intervalle de valeurs). 

12. Représenter un vecteur déplacement et un vecteur vitesse sur deux pour les
deux avions entre les points n°14 et n°18 avec un facteur d'échelle de e=30.  
"""

"""                                 
# Suite du programme   
# tracé des vecteurs toutes les k positions
k=2

      
#-----Tracé des vecteurs déplacement-----
# boucle for pour tracer les différents vecteurs déplacement
# La commande len(t) indique le nombre de valeurs dans la liste t.
# Dans la boucle for i prend successivement les valeurs 0,k,2k,...,nk<len(t)-1
for i in range(0,len(t)-1,k) :    
    plt.arrow(x1[i], y1[i], x1[i+1]-x1[i], y1[i+1]-y1[i],width=200,
              length_includes_head="true",head_length=600, head_width=450,
              fc='m', ec='m')


#-----Tracé des vecteurs vitesse-----
# e est un facteur d'échelle pour la représentation du vecteur vitesse
e=15

# boucle for pour tracer les différents vecteurs vitesse  
for i in range(0,len(t)-1,k) :   
    plt.arrow(x1[i], y1[i], e*(x1[i+1]-x1[i])/(t[i+1]-t[i]),
              e*(y1[i+1]-y1[i])/(t[i+1]-t[i]),width=20,
              length_includes_head="true",head_length=450, head_width=300,
              fc='r',ec='r')

    
#-----affichage de l'échelle de représentation des vecteurs vitesse-----
plt.text(max(min(x1),min(x2)),0,'Echelle du vecteur vitesse :', color='green')
plt.text(max(min(x1),min(x2)),-1000,100, color='green') # affichage 100 m/s
plt.text(max(min(x1),min(x2))+1500,-1000,' m.s$^{-1}$', color='green')
# flèche de longueur correspondant à 100 m/s
plt.arrow(max(min(x1),min(x2)),-2000, 100*e, 0 ,width=20,
              length_includes_head="true", head_length=200,
              head_width=300, fc='g', ec='g') 
  
plt.show()
"""