# Activité 8 - Programme pour la balance électronique expérimentale.
# Numérise la tension Ur présente aux bornes de la résistance R et appliquée
# entre l'entrée analogique 0 et la masse GND.
# Affiche la valeur moyenne de Ur (réalisée sur une seconde et à 2 décimales)
# dans le moniteur série (le dernier 0 affiché de Ur n'est pas significatif, d'après
# les variables utilisées dans le programme)
# Calcule la masse m en g en utilisant le modèle Ur=f(m) tiré de la courbe des
# variations de tension Ur aux bornes de la résistance R en fonction de la
# masse m déposée sur le plateau.
# Lorsque le programme est téléchargé dans la micro:bit, les données sont visualisées
# sur le moniteur série (REPL dans l'éditeur Mu).
# Pour un bon fonctionnement du moniteur REPL, une fois ce dernier démarré,
# appuyer une fois sur le bouton RESET de la carte micro:bit.
#
from microbit import *  # Import de la bibliothèque micro:bit
# Définition des variables
x = 0           # variable pour la tension numérisée entre pin0 et GND
Ur = 0          # variable pour le calcul de la valeur moyenne de la tension numérisée en V
somme = 0       # La variable somme est utilisée pour le calcul de  la moyenne de Ur
while True:     # démarre une boucle infinie
    for i in range(100):     # démarre une boucle de 100 mesures
        x = pin0.read_analog()  # numérisation de la tension de l'entrée 0
        somme = somme + x       # somme des valeurs de x
        sleep(10)               # toutes les 10 ms
    Ur = somme*3.3/102300    # Calcul de la valeur moyenne de la tension numérisée Ur
    print('')  # Passe une ligne
    print('Tension Ur = ', round(Ur, 2), ' V')  # Affichage de la valeur moyenne de la tension numérisée à 2 décimales
    # m = ....    # Masse m calculée à partir de Ur d'après le modèle m = f(Ur)
    # if ? :      # si la masse calculée est inférieure à 5 g alors elle est considérée comme nulle
    # m = 0
    print('Masse = ', ' ? ', ' ? ')
    sleep(2000)     # délai de 2 s avant de revenir au début de la boucle
    somme = 0       # réinitialise la valeur de somme