# Chapitre 9 : Description du mouvement 
# Activité expérimentale 6 : Guidage des avions 
# Code source Python "niveau intermédiaire"
# 
# ENONCE
#1. REALISER
#c) Compléter le code source pour proposer un programme permettant 
#   de représenter :
#   - les trajectoires des deux avions ;


"""
1. Les positions des avions relevées avec le pointage ont déjà été entrées
dans le code source ci-dessous.
Exécuter le programme pour représenter la trajectoire y1=f(x1) de l'avion 1. 

2. Ajouter une ligne au code source ci-dessous pour représenter en bleu la
trajectoire y2=f(x2) de l'avion 2 (bleu = b).
Enregistrer puis exécuter  le programme pour représenter les trajectoires des 
deux avions. 

3. Lire les informations données en dessous de ce premier programme pour
répondre à la suite de la question.
"""

#Début du programme
import matplotlib.pyplot as plt

#-----Coordonnées des positions des deux avions---
t=[0.0, 20.0, 40.0, 60.0, 80.0, 100.0, 120.0, 140.0, 160.0, 180.0, 200.0, 220.0
   , 240.0, 260.0, 280.0, 300.0, 320.0, 340.0]
x1=[3.52E4, 3.79E4, 4.04E4, 4.27E4, 4.52E4, 4.62E4, 4.60E4, 4.60E4, 4.60E4, 
    4.37E4, 4.13E4, 3.89E4, 3.65E4, 3.41E4, 3.21E4, 3.02E4, 2.81E4, 2.61E4]
y1=[-9.67E3, -9.09E3, -8.38E3, -7.68E3, -6.92E3, -4.69E3, -2.52E3, -1.76E2, 
     1.93E3,  3.46E3,  3.99E3,  3.93E3,  3.75E3,  3.63E3,  3.46E3,  3.34E3, 
     3.17E3,  2.99E3]
x2=[4.89E4, 4.69E4, 4.49E4, 4.28E4, 4.11E4, 3.92E4, 3.73E4, 3.53E4, 3.34E4,
    3.14E4, 2.95E4, 2.76E4, 2.59E4, 2.41E4, 2.24E4, 2.08E4, 1.92E4, 1.75E4]
y2=[1.15E4, 1.01E4, 8.79E3, 7.50E3, 6.27E3, 4.98E3, 3.87E3, 3.40E3, 3.52E3,
    3.34E3, 3.22E3, 3.11E3, 2.99E3, 2.87E3, 2.70E3, 2.64E3, 2.46E3, 2.40E3] 
    
#-----Tracé des points et des trajectoires y1=f(x1) et y2=f(x2)------------------                   
# initialisation de la figure, nom et taille de la fenêtre de visualisation
plt.figure('Guidage des avions',figsize=(9,7),dpi=80)
plt.title('Guidage des avions') # titre 
plt.xlabel('x(en m)')              # légende de l'axe des abscisses
plt.ylabel('y(en m)')              # légende de l'axe des ordonnées
plt.axis('equal')               # même échelle sur les axes 

# Représentation des points de coordonnées (x1(t),y1(t)),rouge'r',forme'o',
# taille 2, reliés entre eux par de fines lignes en pointillés d'épaisseur 0,2 
plt.plot(x1,y1,'ro--',ms=2,lw=0.2)

plt.show()

# SUITE DE L'ENONCE
#1. REALISER
#c) Compléter le code source pour proposer un programme permettant
#   de représenter :
#   - les vecteurs vitesse des deux avions.

"""
4. Supprimer l'instruction "plt.show()" à la ligne 54 et les trois guillemets
des lignes 107 et 131.
Enregistrer puis exécuter le programme pour représenter des vecteurs vitesse 
de l'avion 1 en rouge.
Supprimer les guillemets lignes 95 et 106.
Enregistrer puis exécuter le programme pour représenter des vecteurs
déplacement de l'avion 1 en magenta.

5. Ajouter deux lignes au code source ci-dessous pour représenter  
des vecteurs déplacement (en cyan) et  des vecteurs vitesse 
(plus fin et en bleu) de l'avion 2 (largeur: width=80 ; bleu = b ; cyan = c).

6. Ajouter trois guillemets dans différentes lignes du code source pour 
représenter uniquement :
 - les vecteurs déplacement des deux avions ;
 - les vecteurs vitesse des deux avions.
 
7. Modifier le code source ci-dessous pour représenter un vecteur vitesse
toutes les positions (au lieu d'un vecteur vitesse toutes les 2
positions).

8. Modifier à nouveau le code source ci-dessous pour demander dans la console 
les positions des tracés des vecteurs vitesse en intégrant notamment, après la 
ligne "#tracé des vecteurs toutes les k positions", la commande : 
k=int(input('Tracé des vecteurs toutes les k positions : k = '))   
"""


# Suite du programme   
# tracé des vecteurs toutes les k positions
k=2

"""         
#-----Tracé des vecteurs déplacement-----
# boucle for pour tracer les différents vecteurs déplacement
# La commande len(t) indique le nombre de valeurs dans la liste t.
# Dans la boucle for i prend les valeurs 0, k, 2k,..., nk < len(t)-1 = 17)
for i in range(0,len(t)-1,k):
    
    plt.arrow(x1[i], y1[i], x1[i+1]-x1[i], y1[i+1]-y1[i],width=200,
              length_includes_head="true",fc='m', ec='m')


"""
"""
#-----Tracé des vecteurs vitesse-----
# e est un facteur d'échelle pour la représentation du vecteur vitesse
e=15
# boucle for pour tracer les différents vecteurs vitesse  
for i in range(0,len(t)-1,k) :

    plt.arrow(x1[i], y1[i], e*(x1[i+1]-x1[i])/(t[i+1]-t[i]),
              e*(y1[i+1]-y1[i])/(t[i+1]-t[i]),
              length_includes_head="true",width=80,fc='r',ec='r')
  
    


#-----affichage de l'échelle de représentation des vecteurs vitesse-----
plt.text(max(min(x1),min(x2)),0,'Echelle du vecteur vitesse :', color='green')
plt.text(max(min(x1),min(x2)),-1000,100, color='green') # affichage 100 m/s
plt.text(max(min(x1),min(x2))+1500,-1000,' m.s$^{-1}$', color='green')
# flèche de longueur correspondant à 100 m/s
plt.arrow(max(min(x1),min(x2)),-2000, 100*e, 0 ,width=20,
              length_includes_head="true", head_length=200,
              head_width=300, fc='g', ec='g') 
   
plt.show()
"""