from matplotlib import pyplot as plt

t = [0,1,2,3,4,5]  # Domaine des dates (en s)
x = [0,2,4,6,8,10] # Domaine des abscisses (en m)
y = [0,0,0,0,0,0]  # Domaine des ordonnées (en m)

# Figure représentant la trajectoire y=f(x)
plt.figure('Positions successives d\'un point en mouvement')
plt.xlabel('x(en m)')
plt.ylabel('y(en m)')
plt.plot(x,y,'ro',ms=2)
plt.axis('equal')

# Tracé des vecteurs vitesse 
for i in range(0,5) :
    plt.arrow(x[i], y[i], 0.8*(x[i+1]-x[i])/(t[i+1]-t[i]),
    0.8*(y[i+1]-y[i])/(t[i+1]-t[i]),width=0.05,
    length_includes_head="true",color='c')

plt.show() 

                   