#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# ====================================================================
# 2C16 Activité 6 Initiation
# Programme permettant de représenter et de modéliser
# la caractéristique U=f(I) d'une photorésistance 
# ====================================================================

import numpy as np                        
from matplotlib import pyplot as plt      

# Définition de 2 listes pour les 2 variables U et I
U=[0.0, ......................]    # U (en V)
I=[0.00, ......................]   # I (en mA)

# Affichage du nuage de points de coordonnées (I,U): U=f(I)                 
plt.figure('Etude d\'une photorésistance') # Initialise la figure
plt.title('Caractéristique U=f(I)')        # Titre du graphe
plt.xlabel('I (en mA)')                    # Légende axe I
plt.ylabel('U (en V)')                     # Légende axe U
plt.axis([min(I),max(I),min(U),max(U)])    # Min et max des axes
plt.plot(I,U,'r+',ms=10,label='U=f(I) exp')# Trace le nuage de points
                                           # '+' rouge de taille 10

# Modélisation du nuage de points par la droite d'équation U_mod=a*I+b

# Calcule les coefficients de la droite modélisant le nuage
# de points et les range dans un tableau nommé Modele
Modele = np.polyfit(I,U,1)

# Affecte les coefficients du modèle aux variables a et b               
a,b = [coef for coef in Modele]
          
# Pour chaque valeur i de l'intensité, calcule l'ordonnée donnée par
# la modélisation et range les ordonnées dans une liste appelée U_mod
U_mod = [a*i+b for i in I] 

# Trace les points de coordonnées I et U_mod en bleu et reliés             
plt.plot(I,U_mod,'b-',label='U=f(I) modélisé')  

# Affiche l’équation de la droite en arrondissant les coefficients a et b
# à 1 chiffre après la virgule et en précisant les unités de I et U
print('Expression du modèle') 
if (round(b,1)==0.0):                
    print('fonction linéaire : U (en V) = ',round(a,1),'x I (en mA)')
else:    
    print('fonction affine : U (en V)=',round(a,1),'x I (en mA) +(',round(b,1),')')  

plt.grid()                         # Affiche une grille
plt.legend()                       # Affiche la légende
plt.show()                         # Affiche la figure